/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.building.module;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.buildings.modules.IBuildingEventsModule;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Tuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.building.module.AbstractModuleWithExternalWorkingBlocks;
import steve_gall.minecolonies_compatibility.api.common.building.module.INetworkStorageView;
import steve_gall.minecolonies_compatibility.api.common.building.module.NetworkStorageViewRegistry;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.util.StreamUtils;

public class NetworkStorageModule
extends AbstractModuleWithExternalWorkingBlocks
implements IBuildingEventsModule {
    public static final String TAG_POSTION_DIRECTIONS = MineColoniesCompatibility.rl("position_directions").toString();
    private static final List<Direction> VIEW_DIRECTIONS = new ArrayList<Direction>();
    private boolean isDestroyed = false;
    private final Map<BlockPos, Direction> directions = new HashMap<BlockPos, Direction>();

    public void onItemIncremented(ItemStack stack) {
        this.getBuilding().getColony().getRequestManager().onColonyUpdate(request -> this.testDeliverable((IRequest<?>)request, stack));
    }

    private boolean testDeliverable(IRequest<?> request, ItemStack stack) {
        IDeliverable deliverable;
        IRequestable iRequestable = request.getRequest();
        return iRequestable instanceof IDeliverable && (deliverable = (IDeliverable)iRequestable).matches(stack);
    }

    @Override
    public boolean isWorkingBlock(@NotNull LevelReader level, @NotNull BlockPos pos, @NotNull BlockState state) {
        if (this.containsWorkingBlock(pos)) {
            return this.getOwnLinkedViews(pos).findAny().isPresent();
        }
        return NetworkStorageModule.getUnlinkedView(level, pos) != null;
    }

    public Stream<INetworkStorageView> getExtractableBlocks() {
        return this.getRegisteredBlocks().stream().flatMap(this::getOwnLinkedViews).filter(m -> NetworkStorageModule.canExtract(m));
    }

    public static boolean canExtract(@Nullable INetworkStorageView view) {
        return view != null && view.isActive() && view.canExtract();
    }

    public Stream<INetworkStorageView> getInsertableBlocks() {
        return this.getRegisteredBlocks().stream().flatMap(this::getOwnLinkedViews).filter(m -> NetworkStorageModule.canInsert(m));
    }

    public static boolean canInsert(@Nullable INetworkStorageView view) {
        return view != null && view.isActive() && view.canInsert();
    }

    public int getMatchingItemStackCount(ItemStack itemStack, int count, boolean ignoreNBT, boolean ignoreDamage, int leftOver) {
        return this.getMatchingItemStackCount(stack -> ItemStackUtils.compareItemStacksIgnoreStackSize((ItemStack)itemStack, (ItemStack)stack, (!ignoreDamage ? 1 : 0) != 0, (!ignoreNBT ? 1 : 0) != 0), count, leftOver);
    }

    public int getMatchingItemStackCount(Predicate<ItemStack> predicate, int count, int leftOver) {
        int totalCountFound = 0 - leftOver;
        for (ItemStack stack : StreamUtils.toIterable(this.getExtractableBlocks().flatMap(view -> view.getAllStacks().filter(predicate)))) {
            if ((totalCountFound += stack.m_41613_()) < count) continue;
            return totalCountFound;
        }
        return totalCountFound;
    }

    public boolean hasMatchingItemStack(ItemStack itemStack, int count, boolean ignoreNBT, boolean ignoreDamage, int leftOver) {
        return this.getMatchingItemStackCount(itemStack, count, ignoreNBT, ignoreDamage, leftOver) >= count;
    }

    public List<Tuple<ItemStack, BlockPos>> getMatchingItemStacks(Predicate<ItemStack> predicate, int limit) {
        ArrayList<Tuple<ItemStack, BlockPos>> list = new ArrayList<Tuple<ItemStack, BlockPos>>();
        int remained = limit;
        block0: for (INetworkStorageView view : StreamUtils.toIterable(this.getExtractableBlocks())) {
            for (ItemStack stack : StreamUtils.toIterable(view.getAllStacks().filter(predicate))) {
                if (remained <= 0) continue block0;
                for (ItemStack splited : this.split(stack, remained)) {
                    list.add((Tuple<ItemStack, BlockPos>)new Tuple((Object)splited, (Object)view.getPos()));
                    remained -= splited.m_41613_();
                }
            }
        }
        return list;
    }

    private List<ItemStack> split(ItemStack stack, int limit) {
        int count;
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        int maxStackSize = stack.m_41741_();
        for (count = Math.min(stack.m_41613_(), limit); count > maxStackSize; count -= maxStackSize) {
            list.add(stack.m_255036_(maxStackSize));
        }
        list.add(stack.m_255036_(count));
        return list;
    }

    public void dump(IItemHandlerModifiable itemHandler) {
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            for (INetworkStorageView view : StreamUtils.toIterable(this.getInsertableBlocks())) {
                ItemStack stack = itemHandler.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                ItemStack remained = view.insertItem(stack.m_41777_(), false);
                itemHandler.setStackInSlot(i, remained);
            }
        }
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        ListTag directionsTag = compound.m_128437_(TAG_POSTION_DIRECTIONS, 10);
        this.directions.clear();
        for (int i = 0; i < directionsTag.size(); ++i) {
            CompoundTag entryTag = directionsTag.m_128728_(i);
            BlockPos pos = NbtUtils.m_129239_((CompoundTag)entryTag.m_128469_("pos"));
            String direction = entryTag.m_128461_("direction");
            this.directions.put(pos, Direction.m_122402_((String)direction));
        }
    }

    @Override
    public void serializeNBT(@NotNull CompoundTag compound) {
        super.serializeNBT(compound);
        ListTag directionsTag = new ListTag();
        compound.m_128365_(TAG_POSTION_DIRECTIONS, (Tag)directionsTag);
        for (Map.Entry<BlockPos, Direction> entry : this.directions.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)entry.getKey()));
            entryTag.m_128359_("direction", entry.getValue().m_7912_());
            directionsTag.add((Object)entryTag);
        }
    }

    public void serializeToView(FriendlyByteBuf buf) {
        super.serializeToView(buf);
        buf.m_236828_(this.getWorkingBlocks().toList(), FriendlyByteBuf::m_130064_);
        buf.m_236828_(this.directions.entrySet(), (buf2, data) -> {
            buf2.m_130064_((BlockPos)data.getKey());
            buf2.m_130068_((Enum)data.getValue());
        });
    }

    public void onLink(INetworkStorageView view) {
        this.addWorkingBlock(view.getPos());
        Direction direction = view.getDirection();
        if (direction != null) {
            this.directions.put(view.getPos(), direction);
        }
    }

    public void onUnlink(INetworkStorageView view) {
        this.removeWorkingBlock(view.getPos());
        this.directions.remove(view.getPos());
    }

    @Override
    @Nullable
    protected AbstractEntityCitizen getPathFindingCitizen() {
        Set citizens = this.building.getAllAssignedCitizen();
        return citizens.stream().findAny().flatMap(ICitizenData::getEntity).orElse(null);
    }

    @Override
    protected void onWorkingBlockAdded(@NotNull BlockPos pos) {
        super.onWorkingBlockAdded(pos);
        this.link(pos);
    }

    @Override
    protected void onWorkingBlockRemoved(@Nullable BlockPos pos) {
        super.onWorkingBlockRemoved(pos);
        this.unlink(pos);
    }

    @Nullable
    public Stream<INetworkStorageView> getOwnLinkedViews(BlockPos pos) {
        Level level = this.building.getColony().getWorld();
        return NetworkStorageModule.getAllViews((LevelReader)level, pos, view -> view.getLinkedModule() == this);
    }

    private void link(BlockPos pos) {
        Level level = this.building.getColony().getWorld();
        INetworkStorageView view = NetworkStorageModule.getUnlinkedView((LevelReader)level, pos);
        if (view != null) {
            view.link(this);
        }
    }

    private void unlink(BlockPos pos) {
        this.getOwnLinkedViews(pos).forEach(view -> view.unlink());
    }

    public static Stream<INetworkStorageView> getAllViews(LevelReader level, BlockPos pos, Predicate<INetworkStorageView> predicate) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity == null) {
            return Stream.empty();
        }
        return VIEW_DIRECTIONS.stream().map(direction -> NetworkStorageViewRegistry.select(blockEntity, direction)).filter(view -> view != null && (predicate == null || predicate.test((INetworkStorageView)view)));
    }

    @Nullable
    public static INetworkStorageView getUnlinkedView(LevelReader level, BlockPos pos) {
        return NetworkStorageModule.getAllViews(level, pos, view -> view.getLinkedModule() == null).findAny().orElse(null);
    }

    public void onDestroyed() {
        this.isDestroyed = true;
        this.getRegisteredBlocks().forEach(this::unlink);
    }

    public boolean isDestroyed() {
        return this.isDestroyed;
    }

    static {
        VIEW_DIRECTIONS.add(null);
        VIEW_DIRECTIONS.addAll(Arrays.asList(Direction.values()));
    }
}

