/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.building.module;

import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.util.BlockPosUtil;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import steve_gall.minecolonies_compatibility.api.common.building.module.INetworkStorageView;
import steve_gall.minecolonies_compatibility.core.common.building.module.NetworkStorageModule;
import steve_gall.minecolonies_compatibility.core.common.building.module.NetworkStorageModuleView;
import steve_gall.minecolonies_compatibility.core.common.init.ModBuildingModules;

public abstract class AbstractNetworkStorageView
implements INetworkStorageView {
    private static final String TAG_COLONY_ID = "colonyId";
    private static final String TAG_WAREHOUSE_POS = "warehousePos";
    private int colonyId = 0;
    private Optional<BlockPos> warehousePos = Optional.empty();
    private NetworkStorageModule module = null;

    @Override
    public void link(NetworkStorageModule module) {
        if (module == null || module.isDestroyed()) {
            return;
        }
        IBuilding building = module.getBuilding();
        this.colonyId = building.getColony().getID();
        this.warehousePos = Optional.of(building.getID());
        this.module = module;
        this.module.onLink(this);
    }

    @Override
    public void unlink() {
        NetworkStorageModule module = this.getLinkedModule0();
        this.colonyId = 0;
        this.warehousePos = Optional.empty();
        this.module = null;
        if (module != null) {
            module.onUnlink(this);
        }
    }

    public boolean read(CompoundTag tag) {
        int colonyId = this.colonyId;
        Optional<BlockPos> warehousePos = this.warehousePos;
        this.colonyId = tag.m_128451_(TAG_COLONY_ID);
        this.warehousePos = tag.m_128441_(TAG_WAREHOUSE_POS) ? Optional.of(BlockPosUtil.read((CompoundTag)tag, (String)TAG_WAREHOUSE_POS)) : Optional.empty();
        return this.colonyId != colonyId || !this.warehousePos.equals(warehousePos);
    }

    public CompoundTag write() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_(TAG_COLONY_ID, this.colonyId);
        this.warehousePos.ifPresent(p -> BlockPosUtil.write((CompoundTag)tag, (String)TAG_WAREHOUSE_POS, (BlockPos)p));
        return tag;
    }

    public boolean read(FriendlyByteBuf buffer) {
        int colonyId = this.colonyId;
        Optional<BlockPos> warehousePos = this.warehousePos;
        this.colonyId = buffer.readInt();
        this.warehousePos = buffer.m_236860_(FriendlyByteBuf::m_130135_);
        return this.colonyId != colonyId || !this.warehousePos.equals(warehousePos);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.colonyId);
        buffer.m_236835_(this.warehousePos, FriendlyByteBuf::m_130064_);
    }

    @Override
    public NetworkStorageModule getLinkedModule() {
        NetworkStorageModule module = this.getLinkedModule0();
        if (module == null || module.isDestroyed()) {
            if (!this.warehousePos.isEmpty()) {
                this.unlink();
            }
            return null;
        }
        return module;
    }

    @Override
    public NetworkStorageModuleView getLinkedModuleView() {
        if (this.warehousePos.isEmpty()) {
            return null;
        }
        IColonyView colony = MinecoloniesAPIProxy.getInstance().getColonyManager().getColonyView(this.colonyId, this.getLevel().m_46472_());
        if (colony == null) {
            return null;
        }
        IBuildingView building = colony.getBuilding(this.warehousePos.get());
        if (building == null) {
            return null;
        }
        return (NetworkStorageModuleView)building.getModuleView(ModBuildingModules.NETWORK_STORAGE);
    }

    private NetworkStorageModule getLinkedModule0() {
        if (this.module == null) {
            if (this.warehousePos.isEmpty()) {
                return null;
            }
            IColony colony = MinecoloniesAPIProxy.getInstance().getColonyManager().getColonyByWorld(this.colonyId, this.getLevel());
            if (colony == null) {
                return null;
            }
            IBuilding building = colony.getBuildingManager().getBuilding(this.warehousePos.get());
            if (building == null) {
                return null;
            }
            this.module = (NetworkStorageModule)building.getModule(ModBuildingModules.NETWORK_STORAGE);
        }
        return this.module;
    }
}

