/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.api.common.requestsystem;

import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.crafting.IngredientHelper;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.IDeliverableObject;

public class IngredientDeliverable
implements IDeliverableObject {
    public static final ResourceLocation ID = MineColoniesCompatibility.rl("ingredient");
    @NotNull
    private final Ingredient ingredient;
    @NotNull
    private final String description;
    private final int count;
    private final int minCount;

    public static IngredientDeliverable deserialize(@NotNull IFactoryController controller, @NotNull CompoundTag tag) {
        Ingredient ingredient = IngredientHelper.fromJson(tag.m_128461_("ingredient"));
        String description = tag.m_128461_("description");
        int count = tag.m_128451_("count");
        int minCount = tag.m_128451_("minCount");
        return new IngredientDeliverable(ingredient, description, count, minCount);
    }

    public static void serialize(@NotNull IFactoryController controller, @NotNull CompoundTag tag, @NotNull IngredientDeliverable request) {
        tag.m_128359_("ingredient", IngredientHelper.toJson(request.ingredient));
        tag.m_128359_("description", request.description);
        tag.m_128405_("count", request.count);
        tag.m_128405_("minCount", request.minCount);
    }

    public IngredientDeliverable(@NotNull Ingredient ingredient, @NotNull String description, int count) {
        this(ingredient, description, count, count);
    }

    public IngredientDeliverable(@NotNull Ingredient ingredient, @NotNull String description, int count, int minCount) {
        this.ingredient = ingredient;
        this.description = description;
        this.count = count;
        this.minCount = Math.min(count, minCount);
    }

    @NotNull
    public ResourceLocation getId() {
        return ID;
    }

    @NotNull
    public Component getShortDisplayString() {
        return Component.m_237115_((String)this.description);
    }

    @NotNull
    public List<ItemStack> getDisplayStacks() {
        return IngredientHelper.getStacks(this.ingredient);
    }

    @NotNull
    public IDeliverableObject copyWithCount(int newCount) {
        return new IngredientDeliverable(this.ingredient, this.description, newCount, this.minCount);
    }

    public int getCount() {
        return this.count;
    }

    public int getMinimumCount() {
        return this.minCount;
    }

    public boolean matches(@NotNull ItemStack stack) {
        return this.ingredient.test(stack);
    }

    @NotNull
    public Ingredient getIngredient() {
        return this.ingredient;
    }
}

