/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.api.common.plant;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantPositonContext;

public class PlantBlockContext
extends PlantPositonContext {
    @NotNull
    private final BlockState state;

    public PlantBlockContext(@NotNull LevelReader level, @NotNull BlockPos position, @NotNull BlockState state) {
        super(level, position);
        this.state = state;
    }

    @NotNull
    public List<ItemStack> getDrops(@Nullable HarvesterContext harvester) {
        LivingEntity entity = null;
        ItemStack tool = ItemStack.f_41583_;
        if (harvester != null) {
            entity = harvester.getEntity();
            tool = harvester.getTool();
        }
        return this.getDrops(entity, tool);
    }

    @NotNull
    public List<ItemStack> getDrops(@Nullable LivingEntity entity, @NotNull ItemStack tool) {
        LevelReader levelReader = this.getLevel();
        if (levelReader instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelReader;
            BlockState state = this.getState();
            BlockPos position = this.getPosition();
            tool = tool.m_41777_();
            Map map = EnchantmentHelper.m_44831_((ItemStack)tool);
            map.remove(Enchantments.f_44985_);
            EnchantmentHelper.m_44865_((Map)map, (ItemStack)tool);
            return Block.m_49874_((BlockState)state, (ServerLevel)level, (BlockPos)position, null, (Entity)entity, (ItemStack)tool);
        }
        return Collections.emptyList();
    }

    @NotNull
    public BlockState getState() {
        return this.state;
    }

    public static void replant(@NotNull PlantBlockContext context, @NotNull List<ItemStack> drops, BlockState replantState) {
        LevelReader levelReader;
        Block block = context.getState().m_60734_();
        boolean canReplant = false;
        for (int i = 0; i < drops.size(); ++i) {
            BlockItem item;
            ItemStack stack = drops.get(i);
            Item item2 = stack.m_41720_();
            if (!(item2 instanceof BlockItem) || (item = (BlockItem)item2).m_40614_() != block) continue;
            canReplant = true;
            stack.m_41774_(1);
            if (!stack.m_41619_()) break;
            drops.remove(i);
            break;
        }
        if ((levelReader = context.getLevel()) instanceof LevelWriter) {
            LevelWriter level = (LevelWriter)levelReader;
            level.m_7731_(context.getPosition(), canReplant ? replantState : Blocks.f_50016_.m_49966_(), 2);
        }
    }
}

