/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.api.common.crafting;

import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.crafting.ItemStorage;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.crafting.GenericedRecipeStorage;
import steve_gall.minecolonies_compatibility.api.common.crafting.SimpleGenericRecipe;
import steve_gall.minecolonies_compatibility.core.common.crafting.ItemStorageHelper;
import steve_gall.minecolonies_compatibility.core.common.item.ItemStackHelper;
import steve_gall.minecolonies_compatibility.core.common.util.NBTUtils2;

public abstract class SimpleRecipeStorage<GENERIC_RECIPE extends SimpleGenericRecipe>
extends GenericedRecipeStorage<GENERIC_RECIPE> {
    private final ResourceLocation recipeId;
    private final List<ItemStorage> ingredients;
    private final ItemStack output;
    private final List<ItemStack> secondaryOutputs;
    private GENERIC_RECIPE genericRecipe;

    public SimpleRecipeStorage(@NotNull IFactoryController controller, @NotNull CompoundTag tag) {
        this.recipeId = new ResourceLocation(tag.m_128461_("recipeId"));
        this.ingredients = NBTUtils2.deserializeList(tag, "ingredients", arg_0 -> ((IFactoryController)controller).deserialize(arg_0));
        this.output = ItemStack.m_41712_((CompoundTag)tag.m_128469_("output"));
        this.secondaryOutputs = ItemStorageHelper.getCraftingRemainings(this.ingredients);
    }

    public SimpleRecipeStorage(@NotNull ResourceLocation recipeId, @NotNull List<ItemStorage> ingredients, @NotNull ItemStack output) {
        this.recipeId = recipeId;
        this.ingredients = ItemStorageHelper.filterNotEmpty(ingredients);
        this.output = output;
        this.secondaryOutputs = ItemStorageHelper.getCraftingRemainings(ingredients);
    }

    public void serialize(@NotNull IFactoryController controller, @NotNull CompoundTag tag) {
        tag.m_128359_("recipeId", this.recipeId.toString());
        NBTUtils2.serializeCollection(tag, "ingredients", this.ingredients, arg_0 -> ((IFactoryController)controller).serialize(arg_0));
        tag.m_128365_("output", (Tag)this.output.serializeNBT());
    }

    public int hashCode() {
        return Objects.hash(this.recipeId, this.ingredients, this.output.m_41720_());
    }

    public boolean equals(@NotNull Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SimpleRecipeStorage) {
            SimpleRecipeStorage other = (SimpleRecipeStorage)o;
            return this.recipeId.equals((Object)other.recipeId) && this.ingredients.equals(other.ingredients) && ItemStackHelper.equals(this.output, other.output);
        }
        return false;
    }

    @NotNull
    public ResourceLocation getRecipeId() {
        return this.recipeId;
    }

    @NotNull
    public List<ItemStorage> getInput() {
        return this.ingredients;
    }

    @Override
    @NotNull
    public List<ItemStack> getSecondaryOutputs() {
        return this.secondaryOutputs;
    }

    @NotNull
    public List<ItemStorage> getIngredients() {
        return this.ingredients;
    }

    @Override
    @NotNull
    public GENERIC_RECIPE getGenericRecipe() {
        if (this.genericRecipe == null) {
            this.genericRecipe = (SimpleGenericRecipe)this.getGenericRecipeFactory().create(this.recipeId, ItemStorageHelper.getStacksLists(this.ingredients), this.output);
        }
        return this.genericRecipe;
    }

    @NotNull
    protected abstract GenericRecipeFactory<GENERIC_RECIPE> getGenericRecipeFactory();

    public static interface GenericRecipeFactory<GENERIC_RECIPE> {
        @NotNull
        public GENERIC_RECIPE create(@NotNull ResourceLocation var1, @NotNull List<List<ItemStack>> var2, @NotNull ItemStack var3);
    }
}

