/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.api.common.building.module;

import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.crafting.IRecipeStorage;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.building.module.IModuleWithExternalWorkingBlocks;
import steve_gall.minecolonies_compatibility.core.common.util.InteractionMessageHelper;

public interface ICraftingModuleWithExternalWorkingBlocks
extends ICraftingBuildingModule,
IModuleWithExternalWorkingBlocks {
    default public boolean needWorkingBlock(@NotNull IRecipeStorage recipeStorage) {
        return true;
    }

    @NotNull
    default public Component getWorkingBlockNotFoundMessage(@NotNull IRecipeStorage recipeStorage) {
        if (recipeStorage.getIntermediate() == Blocks.f_50016_) {
            return InteractionMessageHelper.getWorkingBlockNotFound();
        }
        return InteractionMessageHelper.getWorkingBlockNotFound(recipeStorage.getIntermediate());
    }

    @NotNull
    default public BlockPos getHitPosition(@NotNull BlockPos pos) {
        return pos;
    }

    @NotNull
    default public BlockPos getParticlePosition(@NotNull BlockPos pos) {
        return this.getHitPosition(pos);
    }

    @NotNull
    default public Stream<BlockPos> getRecipeWorkingBlocks(@NotNull IRecipeStorage recipeStorage) {
        Level level = this.getBuilding().getColony().getWorld();
        return this.getWorkingBlocks().filter(pos -> {
            BlockState state = level.m_8055_(pos);
            return this.canBlockRecipeWorking(level, (BlockPos)pos, state, recipeStorage);
        });
    }

    default public boolean canBlockRecipeWorking(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull IRecipeStorage recipeStorage) {
        return true;
    }
}

