/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import ky.someone.mods.gag.GAGUtil;
import ky.someone.mods.gag.item.LabelingToolItem;
import ky.someone.mods.gag.item.PigmentJarItem;
import ky.someone.mods.gag.menu.LabelingMenu;
import ky.someone.mods.gag.misc.Pigment;
import ky.someone.mods.gag.network.LabelerTryRenamePacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LabelingMenuScreen
extends AbstractContainerScreen<LabelingMenu>
implements ContainerListener {
    private static final boolean UNUSED_UI = true;
    private static final ResourceLocation BG = GAGUtil.id("textures/gui/container/labeling_tool.png");
    private EditBox labelBox;

    public LabelingMenuScreen(LabelingMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.f_97728_ = 60;
        this.f_97729_ = 8;
    }

    protected void m_7856_() {
        super.m_7856_();
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        this.labelBox = new EditBox(this.f_96547_, i + 62, j + 24, 103, 12, LabelingToolItem.TITLE);
        this.labelBox.m_94190_(false);
        this.labelBox.m_94202_(-1);
        this.labelBox.m_94205_(-1);
        this.labelBox.m_94182_(false);
        this.labelBox.m_94199_(50);
        this.labelBox.m_94144_("");
        this.labelBox.m_94151_(this::nameChanged);
        this.m_7787_((GuiEventListener)this.labelBox);
        this.m_264313_((GuiEventListener)this.labelBox);
        this.labelBox.m_94186_(false);
        ((LabelingMenu)this.f_97732_).m_38893_(this);
    }

    public void m_7861_() {
        super.m_7861_();
        ((LabelingMenu)this.f_97732_).m_38943_(this);
    }

    public void m_181908_() {
        super.m_181908_();
        this.labelBox.m_94120_();
    }

    public void m_6574_(Minecraft minecraft, int i, int j) {
        String name = this.labelBox.m_94155_();
        this.m_6575_(minecraft, i, j);
        this.labelBox.m_94144_(name);
    }

    public boolean m_7933_(int i, int j, int k) {
        if (i == 256) {
            this.f_96541_.f_91074_.m_6915_();
        }
        if (this.labelBox.m_7933_(i, j, k)) {
            return true;
        }
        if (this.labelBox.m_94204_()) {
            return true;
        }
        return super.m_7933_(i, j, k);
    }

    public void m_88315_(GuiGraphics graphics, int i, int j, float f) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, i, j, f);
        RenderSystem.disableBlend();
        this.labelBox.m_88315_(graphics, i, j, f);
        this.m_280072_(graphics, i, j);
    }

    public void m_7286_(GuiGraphics graphics, float f, int i, int j) {
        int cx = (this.f_96543_ - this.f_97726_) / 2;
        int cy = (this.f_96544_ - this.f_97727_) / 2;
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)cx, (float)cy, 0.0f);
        graphics.m_280218_(BG, 0, 0, 0, 0, this.f_97726_, this.f_97727_);
        graphics.m_280218_(BG, 6, 40, 0, 166, 164, 31);
        graphics.m_280218_(BG, 59, 20, 0, 197, 110, 16);
        graphics.m_280218_(BG, 76, 41, 176, 0, 18, 18);
        graphics.m_280218_(BG, 134, 41, 176, 0, 18, 18);
        graphics.m_280218_(BG, 103, 43, 176, 18, 22, 15);
        ItemStack pigmentStack = ((LabelingMenu)this.f_97732_).m_38853_(1).m_7993_();
        if (PigmentJarItem.isNonEmptyJar(pigmentStack)) {
            Pigment pigment = Objects.requireNonNull(PigmentJarItem.getPigment(pigmentStack));
            float ratio = (float)pigment.amount() / 64.0f;
            poseStack.m_85836_();
            if (ratio > 0.0f) {
                int u = 1;
                int v = 214;
                int x = 7;
                int y = 64;
                int w = (int)(162.0f * ratio);
                int h = 5;
                int color = pigment.rgb();
                float rf = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
                float gf = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
                float bf = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
                graphics.m_280246_(rf, gf, bf, 1.0f);
                graphics.m_280218_(BG, x, y, u, v, w, h);
            }
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    private void nameChanged(String name) {
        if (!name.isEmpty()) {
            String s = name;
            Slot slot = ((LabelingMenu)this.f_97732_).m_38853_(0);
            if (slot.m_6657_() && !slot.m_7993_().m_41788_() && name.equals(slot.m_7993_().m_41786_().getString()) && !((LabelingMenu)this.f_97732_).m_38853_(1).m_6657_()) {
                s = "";
            }
            ((LabelingMenu)this.f_97732_).setName(s);
            new LabelerTryRenamePacket(s).sendToServer();
        }
    }

    public void m_7934_(AbstractContainerMenu menu, int i, ItemStack stack) {
        if (i == 0) {
            this.labelBox.m_94144_(stack.m_41619_() ? "" : stack.m_41786_().getString());
            this.labelBox.m_94186_(!stack.m_41619_());
            this.m_7522_((GuiEventListener)this.labelBox);
        } else if (i == 1) {
            this.nameChanged(this.labelBox.m_94155_());
        }
    }

    public void m_142153_(AbstractContainerMenu menu, int i, int j) {
    }
}

