/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.value;

import dev.toma.configuration.config.Configurable;
import dev.toma.configuration.config.adapter.TypeAdapter;
import dev.toma.configuration.config.exception.ConfigValueMissingException;
import dev.toma.configuration.config.format.IConfigFormat;
import dev.toma.configuration.config.validate.NumberRange;
import dev.toma.configuration.config.value.AbstractArrayValue;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.config.value.IConfigValueReadable;
import dev.toma.configuration.config.value.NumericArrayValue;
import dev.toma.configuration.config.value.ValueData;
import java.lang.reflect.Field;
import net.minecraft.network.FriendlyByteBuf;

public class LongArrayValue
extends NumericArrayValue<Long> {
    public LongArrayValue(ValueData<Long[]> valueData) {
        super(valueData, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    @Override
    public NumberRange<Long> getValueRange(Field field) {
        Configurable.Range range = field.getAnnotation(Configurable.Range.class);
        return range != null ? NumberRange.interval(this, range.min(), range.max()) : NumberRange.all(this);
    }

    @Override
    public Long createElementInstance() {
        return 0L;
    }

    @Override
    protected void serialize(IConfigFormat format) {
        format.writeLongArray(this.getId(), (Long[])this.get(IConfigValueReadable.Mode.SAVED));
    }

    @Override
    protected void deserialize(IConfigFormat format) throws ConfigValueMissingException {
        this.setValue(format.readLongArray(this.getId()));
    }

    public static final class Adapter
    extends TypeAdapter<Long[]> {
        @Override
        public void encodeToBuffer(ConfigValue<Long[]> value, FriendlyByteBuf buffer) {
            AbstractArrayValue.saveToBuffer((Long[])value.get(), buffer, FriendlyByteBuf::writeLong);
        }

        @Override
        public Long[] decodeFromBuffer(ConfigValue<Long[]> value, FriendlyByteBuf buffer) {
            return AbstractArrayValue.readFromBuffer(buffer, Long[]::new, FriendlyByteBuf::readLong);
        }

        @Override
        public ConfigValue<Long[]> serialize(TypeAdapter.TypeAttributes<Long[]> attributes, Object instance, TypeAdapter.TypeSerializer serializer) throws IllegalAccessException {
            return new LongArrayValue(ValueData.of(attributes));
        }
    }
}

