/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.value;

import dev.toma.configuration.config.Configurable;
import dev.toma.configuration.config.adapter.TypeAdapter;
import dev.toma.configuration.config.exception.ConfigValueMissingException;
import dev.toma.configuration.config.format.IConfigFormat;
import dev.toma.configuration.config.validate.NumberRange;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.config.value.IConfigValueReadable;
import dev.toma.configuration.config.value.NumericValue;
import dev.toma.configuration.config.value.ValueData;
import java.lang.reflect.Field;
import net.minecraft.network.FriendlyByteBuf;

public class ByteValue
extends NumericValue<Byte> {
    public ByteValue(ValueData<Byte> data) {
        super(data, (byte)-128, (byte)127);
    }

    @Override
    protected NumberRange<Byte> getValueRange(Field field, Byte min, Byte max) {
        Configurable.Range range = field.getAnnotation(Configurable.Range.class);
        return range != null ? NumberRange.interval(this, (byte)Math.max(range.min(), (long)min.byteValue()), (byte)Math.min(range.max(), (long)max.byteValue())) : NumberRange.all(this);
    }

    @Override
    public Byte getValueFromSlider(double sliderValue) {
        NumberRange range = this.getRange();
        int delta = (Byte)range.max() - (Byte)range.min();
        return (byte)((Byte)range.min() + (byte)((double)delta * sliderValue));
    }

    @Override
    protected void serialize(IConfigFormat format) {
        format.writeByte(this.getId(), (Byte)this.get(IConfigValueReadable.Mode.SAVED));
    }

    @Override
    protected void deserialize(IConfigFormat format) throws ConfigValueMissingException {
        this.setValue(format.readByte(this.getId()));
    }

    public static final class Adapter
    extends TypeAdapter<Byte> {
        @Override
        public ConfigValue<Byte> serialize(TypeAdapter.TypeAttributes<Byte> attributes, Object instance, TypeAdapter.TypeSerializer serializer) throws IllegalAccessException {
            return new ByteValue(ValueData.of(attributes));
        }

        @Override
        public void encodeToBuffer(ConfigValue<Byte> value, FriendlyByteBuf buffer) {
            buffer.writeByte((int)((Byte)value.get()).byteValue());
        }

        @Override
        public Byte decodeFromBuffer(ConfigValue<Byte> value, FriendlyByteBuf buffer) {
            return buffer.readByte();
        }

        @Override
        public void setFieldValue(Field field, Object instance, Object value) throws IllegalAccessException {
            field.setByte(instance, (Byte)value);
        }
    }
}

