/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.terminal;

import de.ellpeck.prettypipes.Registry;
import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.misc.EquatableItemStack;
import de.ellpeck.prettypipes.misc.ItemEquality;
import de.ellpeck.prettypipes.network.NetworkItem;
import de.ellpeck.prettypipes.network.NetworkLocation;
import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.packets.PacketGhostSlot;
import de.ellpeck.prettypipes.packets.PacketHandler;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import de.ellpeck.prettypipes.terminal.ItemTerminalBlockEntity;
import de.ellpeck.prettypipes.terminal.containers.CraftingTerminalContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.mutable.MutableInt;

public class CraftingTerminalBlockEntity
extends ItemTerminalBlockEntity {
    public final ItemStackHandler craftItems = new ItemStackHandler(9){

        protected void onContentsChanged(int slot) {
            for (Player playerEntity : CraftingTerminalBlockEntity.this.getLookingPlayers()) {
                playerEntity.f_36096_.m_6199_(null);
            }
        }
    };
    public final ItemStackHandler ghostItems = new ItemStackHandler(9);

    public CraftingTerminalBlockEntity(BlockPos pos, BlockState state) {
        super(Registry.craftingTerminalBlockEntity, pos, state);
    }

    public ItemStack getRequestedCraftItem(int slot) {
        ItemStack stack = this.craftItems.getStackInSlot(slot);
        if (!stack.m_41619_()) {
            return stack;
        }
        return this.ghostItems.getStackInSlot(slot);
    }

    public boolean isGhostItem(int slot) {
        return this.craftItems.getStackInSlot(slot).m_41619_() && !this.ghostItems.getStackInSlot(slot).m_41619_();
    }

    public void setGhostItems(List<PacketGhostSlot.Entry> stacks) {
        this.updateItems(new Player[0]);
        for (int i = 0; i < this.ghostItems.getSlots(); ++i) {
            List<ItemStack> items = stacks.get(i).getStacks(this.f_58857_);
            if (items.isEmpty()) {
                this.ghostItems.setStackInSlot(i, ItemStack.f_41583_);
                continue;
            }
            ItemStack toSet = items.get(0);
            if (items.size() > 1) {
                int highestAmount = 0;
                for (ItemStack stack : items) {
                    PipeBlockEntity pipe;
                    int amount = 0;
                    NetworkItem network = (NetworkItem)this.networkItems.get(new EquatableItemStack(stack, ItemEquality.NBT));
                    if (network != null) {
                        amount = network.getLocations().stream().mapToInt(l -> l.getItemAmount(this.f_58857_, stack, ItemEquality.NBT)).sum();
                    }
                    if (amount <= 0 && highestAmount <= 0 && (pipe = this.getConnectedPipe()) != null) {
                        amount = PipeNetwork.get(this.f_58857_).getCraftableAmount(pipe.m_58899_(), null, stack, new Stack<ItemStack>(), ItemEquality.NBT);
                    }
                    if (amount <= highestAmount) continue;
                    highestAmount = amount;
                    toSet = stack;
                }
            }
            this.ghostItems.setStackInSlot(i, toSet.m_41777_());
        }
        if (!this.f_58857_.f_46443_) {
            ArrayList<PacketGhostSlot.Entry> clients = new ArrayList<PacketGhostSlot.Entry>();
            for (int i = 0; i < this.ghostItems.getSlots(); ++i) {
                clients.add(new PacketGhostSlot.Entry(this.f_58857_, Collections.singletonList(this.ghostItems.getStackInSlot(i))));
            }
            PacketHandler.sendToAllLoaded(this.f_58857_, this.m_58899_(), new PacketGhostSlot(this.m_58899_(), clients));
        }
    }

    public void requestCraftingItems(Player player, int maxAmount, boolean force) {
        PipeBlockEntity pipe = this.getConnectedPipe();
        if (pipe == null) {
            return;
        }
        PipeNetwork network = PipeNetwork.get(this.f_58857_);
        network.startProfile("terminal_request_crafting");
        this.updateItems(new Player[0]);
        int lowestAvailable = CraftingTerminalBlockEntity.getAvailableCrafts(pipe, this.craftItems.getSlots(), i -> ItemHandlerHelper.copyStackWithSize((ItemStack)this.getRequestedCraftItem((int)i), (int)1), this::isGhostItem, s -> {
            NetworkItem item = (NetworkItem)this.networkItems.get(s);
            return item != null ? item.getLocations() : Collections.emptyList();
        }, ItemTerminalBlockEntity.onItemUnavailable(player, force), new Stack<ItemStack>(), ItemEquality.NBT);
        if (lowestAvailable <= 0 && force) {
            lowestAvailable = maxAmount;
        }
        if (lowestAvailable > 0) {
            if (maxAmount < lowestAvailable) {
                lowestAvailable = maxAmount;
            }
            for (int i2 = 0; i2 < this.craftItems.getSlots(); ++i2) {
                ItemStack requested = this.getRequestedCraftItem(i2);
                if (requested.m_41619_()) continue;
                requested = requested.m_41777_();
                requested.m_41764_(lowestAvailable);
                this.requestItemImpl(requested, ItemTerminalBlockEntity.onItemUnavailable(player, force));
            }
            player.m_213846_((Component)Component.m_237110_((String)"info.prettypipes.sending_ingredients", (Object[])new Object[]{lowestAvailable}).m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GREEN)));
        } else {
            player.m_213846_((Component)Component.m_237115_((String)"info.prettypipes.hold_alt"));
        }
        network.endProfile();
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("craft_items", (Tag)this.craftItems.serializeNBT());
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        this.craftItems.deserializeNBT(compound.m_128469_("craft_items"));
        super.m_142466_(compound);
    }

    @Override
    public Component m_5446_() {
        return Component.m_237115_((String)"container.prettypipes.crafting_terminal");
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int window, Inventory inv, Player player) {
        return new CraftingTerminalContainer(Registry.craftingTerminalContainer, window, player, this.f_58858_);
    }

    @Override
    public ItemStack insertItem(BlockPos pipePos, Direction direction, ItemStack remain, boolean simulate) {
        BlockPos pos = pipePos.m_121945_(direction);
        CraftingTerminalBlockEntity tile = Utility.getBlockEntity(CraftingTerminalBlockEntity.class, (BlockGetter)this.f_58857_, pos);
        if (tile != null) {
            remain = remain.m_41777_();
            int lowestSlot = -1;
            do {
                for (int i = 0; i < tile.craftItems.getSlots(); ++i) {
                    int count;
                    ItemStack stack = tile.getRequestedCraftItem(i);
                    int n = count = tile.isGhostItem(i) ? 0 : stack.m_41613_();
                    if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)remain) || !stack.m_41753_() && count >= 1 || lowestSlot >= 0 && (tile.isGhostItem(lowestSlot) || count >= tile.getRequestedCraftItem(lowestSlot).m_41613_())) continue;
                    lowestSlot = i;
                }
                if (lowestSlot < 0) continue;
                ItemStack copy = remain.m_41777_();
                copy.m_41764_(1);
                if (tile.craftItems.insertItem(lowestSlot, copy, simulate).m_41613_() > 0) break;
                remain.m_41774_(1);
                if (!remain.m_41619_()) continue;
                return ItemStack.f_41583_;
            } while (lowestSlot >= 0);
            return ItemHandlerHelper.insertItemStacked((IItemHandler)tile.items, (ItemStack)remain, (boolean)simulate);
        }
        return remain;
    }

    public static int getAvailableCrafts(PipeBlockEntity tile, int slots, Function<Integer, ItemStack> inputFunction, Predicate<Integer> isGhost, Function<EquatableItemStack, Collection<NetworkLocation>> locationsFunction, Consumer<ItemStack> unavailableConsumer, Stack<ItemStack> dependencyChain, ItemEquality ... equalityTypes) {
        PipeNetwork network = PipeNetwork.get(tile.m_58904_());
        int lowestAvailable = Integer.MAX_VALUE;
        HashMap<EquatableItemStack, MutableInt> requiredItems = new HashMap<EquatableItemStack, MutableInt>();
        for (int i = 0; i < slots; ++i) {
            ItemStack requested = inputFunction.apply(i);
            if (requested.m_41619_()) continue;
            MutableInt amount = requiredItems.computeIfAbsent(new EquatableItemStack(requested, equalityTypes), s -> new MutableInt());
            amount.add(requested.m_41613_());
            int fit = Math.max(requested.m_41741_() - (isGhost.test(i) ? 0 : requested.m_41613_()), 1);
            if (lowestAvailable <= fit) continue;
            lowestAvailable = fit;
        }
        for (Map.Entry entry : requiredItems.entrySet()) {
            int craftable;
            EquatableItemStack stack = (EquatableItemStack)entry.getKey();
            int available = 0;
            for (NetworkLocation location : locationsFunction.apply(stack)) {
                int amount = location.getItemAmount(tile.m_58904_(), stack.stack(), equalityTypes);
                if (amount <= 0) continue;
                available += (amount -= network.getLockedAmount(location.getPos(), stack.stack(), null, equalityTypes));
            }
            if ((available /= ((MutableInt)entry.getValue()).intValue()) < lowestAvailable && (craftable = network.getCraftableAmount(tile.m_58899_(), unavailableConsumer, stack.stack(), dependencyChain, equalityTypes)) > 0) {
                available += craftable / ((MutableInt)entry.getValue()).intValue();
            }
            if (available < lowestAvailable) {
                lowestAvailable = available;
            }
            if (available > 0 || unavailableConsumer == null) continue;
            unavailableConsumer.accept(stack.stack());
        }
        return lowestAvailable;
    }
}

