/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.pressurizer;

import de.ellpeck.prettypipes.Registry;
import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.pipe.ConnectionType;
import de.ellpeck.prettypipes.pipe.IPipeConnectable;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import de.ellpeck.prettypipes.pressurizer.PressurizerContainer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class PressurizerBlockEntity
extends BlockEntity
implements MenuProvider,
IPipeConnectable {
    private final ModifiableEnergyStorage storage = new ModifiableEnergyStorage(64000, 512, 0);
    private final LazyOptional<IEnergyStorage> lazyStorage = LazyOptional.of(() -> this.storage);
    private final LazyOptional<IPipeConnectable> lazyThis = LazyOptional.of(() -> this);
    private int lastEnergy;

    public PressurizerBlockEntity(BlockPos pos, BlockState state) {
        super(Registry.pressurizerBlockEntity, pos, state);
    }

    public boolean pressurizeItem(ItemStack stack, boolean simulate) {
        int amount = 100 * stack.m_41613_();
        return this.storage.extractInternal(amount, simulate) >= amount;
    }

    public float getEnergyPercentage() {
        return (float)this.getEnergy() / (float)this.getMaxEnergy();
    }

    public int getEnergy() {
        return this.storage.getEnergyStored();
    }

    public int getMaxEnergy() {
        return this.storage.getMaxEnergyStored();
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("energy", this.getEnergy());
    }

    public void m_142466_(CompoundTag nbt) {
        this.storage.setEnergyStored(nbt.m_128451_("energy"));
        super.m_142466_(nbt);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.prettypipes.pressurizer");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int window, Inventory inv, Player player) {
        return new PressurizerContainer(Registry.pressurizerContainer, window, player, this.f_58858_);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyStorage.cast();
        }
        if (cap == Registry.pipeConnectableCapability) {
            return this.lazyThis.cast();
        }
        return LazyOptional.empty();
    }

    public void m_7651_() {
        super.m_7651_();
        this.lazyStorage.invalidate();
        this.lazyThis.invalidate();
    }

    @Override
    public ConnectionType getConnectionType(BlockPos pipePos, Direction direction) {
        return ConnectionType.CONNECTED;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, PressurizerBlockEntity pressurizer) {
        if (pressurizer.f_58857_.m_46467_() % 10L == 0L) {
            PipeNetwork network = PipeNetwork.get(pressurizer.f_58857_);
            for (Direction dir : Direction.values()) {
                BlockPos offset = pressurizer.f_58858_.m_121945_(dir);
                for (BlockPos node : network.getOrderedNetworkNodes(offset)) {
                    PipeBlockEntity pipe;
                    if (!pressurizer.f_58857_.m_46749_(node) || (pipe = network.getPipe(node)) == null) continue;
                    pipe.pressurizer = pressurizer;
                }
            }
        }
        if (pressurizer.lastEnergy != pressurizer.storage.getEnergyStored() && pressurizer.f_58857_.m_46467_() % 10L == 0L) {
            pressurizer.lastEnergy = pressurizer.storage.getEnergyStored();
            level.m_46717_(pos, state.m_60734_());
            Utility.sendBlockEntityToClients(pressurizer);
        }
    }

    private static class ModifiableEnergyStorage
    extends EnergyStorage {
        public ModifiableEnergyStorage(int capacity, int maxReceive, int maxExtract) {
            super(capacity, maxReceive, maxExtract);
        }

        private void setEnergyStored(int energy) {
            this.energy = energy;
        }

        private int extractInternal(int maxExtract, boolean simulate) {
            int energyExtracted = Math.min(this.energy, maxExtract);
            if (!simulate) {
                this.energy -= energyExtracted;
            }
            return energyExtracted;
        }
    }
}

