/*
 * Decompiled with CFR 0.152.
 */
package com.foozey.gems.item;

import com.foozey.gems.item.attributes.AttributeBuilder;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;

public class ModHoeItem
extends HoeItem {
    private final Function<UUID, Multimap<Attribute, AttributeModifier>> attributes;

    public ModHoeItem(Tier tier, int attackDamageModifier, float attackSpeedModifier, Function<UUID, Multimap<Attribute, AttributeModifier>> attributes, Item.Properties properties) {
        super(tier, attackDamageModifier, attackSpeedModifier, properties);
        this.attributes = attributes;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        Multimap map = super.getAttributeModifiers(slot, stack);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        if (slot == EquipmentSlot.MAINHAND) {
            builder.putAll(map);
            if (this.attributes != null) {
                builder.putAll(this.attributes.apply(AttributeBuilder.uuid(slot, stack)));
            }
        }
        return builder.build();
    }
}

