/*
 * Decompiled with CFR 0.152.
 */
package com.foozey.gems.item;

import com.foozey.gems.item.attributes.AttributeBuilder;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ModArmorItem
extends ArmorItem {
    private final Function<UUID, Multimap<Attribute, AttributeModifier>> attributes;
    private final Component tooltip;

    public ModArmorItem(ArmorMaterial material, ArmorItem.Type type, Function<UUID, Multimap<Attribute, AttributeModifier>> attributes, Component tooltip, Item.Properties properties) {
        super(material, type, properties);
        this.attributes = attributes;
        this.tooltip = tooltip;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        Multimap map = super.getAttributeModifiers(slot, stack);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        if (slot == this.m_266204_().m_266308_()) {
            builder.putAll(map);
            if (this.attributes != null) {
                builder.putAll(this.attributes.apply(AttributeBuilder.uuid(slot, stack)));
            }
        }
        return builder.build();
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        if (this.tooltip != null) {
            tooltipComponents.add(this.tooltip);
        }
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }
}

