/*
 * Decompiled with CFR 0.152.
 */
package com.foozey.gems.event;

import com.foozey.gems.item.shield.ShieldRender;
import com.foozey.gems.util.ItemModelPropertiesProvider;
import com.foozey.gems.util.emissive.EmissiveHorseArmorLayer;
import com.foozey.gems.util.emissive.EmissiveHumanoidArmorLayer;
import com.foozey.gems.util.emissive.EmissiveModelLayers;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HorseModel;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.entity.HorseRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="gems", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEventsMod {
    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemModelPropertiesProvider.bow();
            ItemModelPropertiesProvider.crossbow();
            ItemModelPropertiesProvider.shield();
            ShieldRender.initializeTextures();
        });
    }

    @SubscribeEvent
    public static void registerClientReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)ShieldRender.RENDERER);
    }

    @SubscribeEvent
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        LayerDefinition outer = LayerDefinition.m_171565_((MeshDefinition)HumanoidArmorModel.m_269566_((CubeDeformation)new CubeDeformation(1.025f)), (int)64, (int)32);
        LayerDefinition inner = LayerDefinition.m_171565_((MeshDefinition)HumanoidArmorModel.m_269566_((CubeDeformation)new CubeDeformation(0.525f)), (int)64, (int)32);
        event.registerLayerDefinition(EmissiveModelLayers.PLAYER_INNER_ARMOR_EMISSIVE, () -> inner);
        event.registerLayerDefinition(EmissiveModelLayers.PLAYER_OUTER_ARMOR_EMISSIVE, () -> outer);
        event.registerLayerDefinition(EmissiveModelLayers.PLAYER_SLIM_INNER_ARMOR_EMISSIVE, () -> inner);
        event.registerLayerDefinition(EmissiveModelLayers.PLAYER_SLIM_OUTER_ARMOR_EMISSIVE, () -> outer);
        event.registerLayerDefinition(EmissiveModelLayers.ENTITY_INNER_ARMOR_EMISSIVE, () -> inner);
        event.registerLayerDefinition(EmissiveModelLayers.ENTITY_OUTER_ARMOR_EMISSIVE, () -> outer);
    }

    @SubscribeEvent
    public static void addLayers(EntityRenderersEvent.AddLayers event) {
        String[] types;
        EntityModelSet entityModelSet = event.getEntityModels();
        for (String type : types = new String[]{"default", "slim"}) {
            PlayerRenderer renderer = (PlayerRenderer)event.getSkin(type);
            if (renderer == null) {
                return;
            }
            ModelLayerLocation inner = type.equals("slim") ? EmissiveModelLayers.PLAYER_SLIM_INNER_ARMOR_EMISSIVE : EmissiveModelLayers.PLAYER_INNER_ARMOR_EMISSIVE;
            ModelLayerLocation outer = type.equals("slim") ? EmissiveModelLayers.PLAYER_SLIM_OUTER_ARMOR_EMISSIVE : EmissiveModelLayers.PLAYER_OUTER_ARMOR_EMISSIVE;
            renderer.m_115326_(new EmissiveHumanoidArmorLayer(renderer, new HumanoidArmorModel(entityModelSet.m_171103_(inner)), new HumanoidArmorModel(entityModelSet.m_171103_(outer)), Minecraft.m_91087_().m_91304_()));
        }
        List<EntityType> entities = List.of(EntityType.f_20501_, EntityType.f_20530_, EntityType.f_20458_, EntityType.f_20524_, EntityType.f_20481_, EntityType.f_20511_, EntityType.f_20531_, EntityType.f_20529_);
        for (EntityType entity : entities) {
            LivingEntityRenderer renderer = event.getRenderer(entity);
            if (renderer == null) {
                return;
            }
            ModelLayerLocation inner = EmissiveModelLayers.ENTITY_INNER_ARMOR_EMISSIVE;
            ModelLayerLocation outer = EmissiveModelLayers.ENTITY_OUTER_ARMOR_EMISSIVE;
            renderer.m_115326_(new EmissiveHumanoidArmorLayer(renderer, new HumanoidArmorModel(entityModelSet.m_171103_(inner)), new HumanoidArmorModel(entityModelSet.m_171103_(outer)), Minecraft.m_91087_().m_91304_()));
        }
        HorseRenderer renderer = (HorseRenderer)event.getRenderer(EntityType.f_20457_);
        if (renderer == null) {
            return;
        }
        renderer.m_115326_((RenderLayer)new EmissiveHorseArmorLayer((RenderLayerParent<Horse, HorseModel<Horse>>)renderer, entityModelSet));
    }
}

