/*
 * Decompiled with CFR 0.152.
 */
package com.foozey.gems.data;

import com.foozey.gems.Gems;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.sources.PalettedPermutations;
import net.minecraft.client.renderer.texture.atlas.sources.SingleFile;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.SpriteSourceProvider;

public class ModSpriteSourceProvider
extends SpriteSourceProvider {
    private final SpriteSourceProvider.SourceList shieldPatternsAtlas = this.atlas(SHIELD_PATTERNS_ATLAS);
    private final SpriteSourceProvider.SourceList blocksAtlas = this.atlas(BLOCKS_ATLAS);
    private final SpriteSourceProvider.SourceList armorTrimsAtlas = this.atlas(new ResourceLocation("armor_trims"));

    public ModSpriteSourceProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, existingFileHelper, "gems");
    }

    protected void addSources() {
        this.shieldSource("iron", "golden", "diamond", "netherite", "topaz", "sapphire", "ruby", "dragonyx", "emerald");
        this.trimItemSource("topaz", "sapphire", "ruby", "onyx");
        this.trimModelSource("topaz", "sapphire", "ruby", "onyx");
    }

    private void shieldSource(String ... names) {
        for (String name : names) {
            ResourceLocation shieldLocation = Gems.rl("entity/" + name + "_shield");
            Optional<ResourceLocation> overlayLocation = name.equals("dragonyx") ? Optional.of(Gems.rl("entity/dragonyx_shield_overlay")) : Optional.empty();
            this.shieldPatternsAtlas.addSource((SpriteSource)new SingleFile(shieldLocation, Optional.empty()));
            overlayLocation.ifPresent(resourceLocation -> this.shieldPatternsAtlas.addSource((SpriteSource)new SingleFile(resourceLocation, Optional.empty())));
        }
    }

    private void trimItemSource(String ... materials) {
        List<ResourceLocation> types = List.of(new ResourceLocation("trims/items/leggings_trim"), new ResourceLocation("trims/items/chestplate_trim"), new ResourceLocation("trims/items/helmet_trim"), new ResourceLocation("trims/items/boots_trim"));
        ResourceLocation palette = new ResourceLocation("trims/color_palettes/trim_palette");
        LinkedHashMap<String, ResourceLocation> map = new LinkedHashMap<String, ResourceLocation>();
        for (String material : materials) {
            map.put(material, Gems.rl("trims/color_palettes/" + material));
        }
        this.blocksAtlas.addSource((SpriteSource)new PalettedPermutations(types, palette, map));
    }

    private void trimModelSource(String ... materials) {
        List<ResourceLocation> types = List.of(new ResourceLocation("trims/models/armor/coast"), new ResourceLocation("trims/models/armor/coast_leggings"), new ResourceLocation("trims/models/armor/sentry"), new ResourceLocation("trims/models/armor/sentry_leggings"), new ResourceLocation("trims/models/armor/dune"), new ResourceLocation("trims/models/armor/dune_leggings"), new ResourceLocation("trims/models/armor/wild"), new ResourceLocation("trims/models/armor/wild_leggings"), new ResourceLocation("trims/models/armor/ward"), new ResourceLocation("trims/models/armor/ward_leggings"), new ResourceLocation("trims/models/armor/eye"), new ResourceLocation("trims/models/armor/eye_leggings"), new ResourceLocation("trims/models/armor/vex"), new ResourceLocation("trims/models/armor/vex_leggings"), new ResourceLocation("trims/models/armor/tide"), new ResourceLocation("trims/models/armor/tide_leggings"), new ResourceLocation("trims/models/armor/snout"), new ResourceLocation("trims/models/armor/snout_leggings"), new ResourceLocation("trims/models/armor/rib"), new ResourceLocation("trims/models/armor/rib_leggings"), new ResourceLocation("trims/models/armor/spire"), new ResourceLocation("trims/models/armor/spire_leggings"), new ResourceLocation("trims/models/armor/wayfinder"), new ResourceLocation("trims/models/armor/wayfinder_leggings"), new ResourceLocation("trims/models/armor/shaper"), new ResourceLocation("trims/models/armor/shaper_leggings"), new ResourceLocation("trims/models/armor/silence"), new ResourceLocation("trims/models/armor/silence_leggings"), new ResourceLocation("trims/models/armor/raiser"), new ResourceLocation("trims/models/armor/raiser_leggings"), new ResourceLocation("trims/models/armor/host"), new ResourceLocation("trims/models/armor/host_leggings"));
        ResourceLocation palette = new ResourceLocation("trims/color_palettes/trim_palette");
        LinkedHashMap<String, ResourceLocation> map = new LinkedHashMap<String, ResourceLocation>();
        for (String material : materials) {
            map.put(material, Gems.rl("trims/color_palettes/" + material));
        }
        this.armorTrimsAtlas.addSource((SpriteSource)new PalettedPermutations(types, palette, map));
    }
}

