/*
 * Decompiled with CFR 0.152.
 */
package com.foozey.gems.data;

import com.foozey.gems.Gems;
import com.foozey.gems.data.registries.ModTrimMaterials;
import com.foozey.gems.registry.ModItems;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.loaders.ItemLayerModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ModItemModelProvider
extends ItemModelProvider {
    private static final Map<ResourceKey<TrimMaterial>, Float> TRIM_MATERIALS = new LinkedHashMap<ResourceKey<TrimMaterial>, Float>();

    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "gems", existingFileHelper);
    }

    protected void registerModels() {
        this.simpleItem((Item)ModItems.TOPAZ.get());
        this.simpleItem((Item)ModItems.TOPAZ_SHARDS.get());
        this.simpleItem((Item)ModItems.SAPPHIRE.get());
        this.simpleItem((Item)ModItems.SAPPHIRE_SHARDS.get());
        this.simpleItem((Item)ModItems.RUBY.get());
        this.simpleItem((Item)ModItems.RUBY_SHARDS.get());
        this.simpleItem((Item)ModItems.ONYX.get());
        this.simpleItem((Item)ModItems.ONYX_SHARDS.get());
        this.simpleItem((Item)ModItems.ENDER_BONES.get());
        this.simpleItem((Item)ModItems.ENDER_SCALES.get());
        this.simpleItem((Item)ModItems.CHAINMAIL.get());
        this.simpleItem((Item)ModItems.CHAINMAIL_HORSE_ARMOR.get());
        this.simpleItem((Item)ModItems.NETHERITE_HORSE_ARMOR.get());
        this.simpleItem((Item)ModItems.TOPAZ_HORSE_ARMOR.get());
        this.simpleItem((Item)ModItems.SAPPHIRE_HORSE_ARMOR.get());
        this.simpleItem((Item)ModItems.RUBY_HORSE_ARMOR.get());
        this.simpleItem((Item)ModItems.EMERALD_HORSE_ARMOR.get());
        this.simpleItem((Item)ModItems.TOPAZ_UPGRADE_SMITHING_TEMPLATE.get());
        this.simpleItem((Item)ModItems.SAPPHIRE_UPGRADE_SMITHING_TEMPLATE.get());
        this.simpleItem((Item)ModItems.RUBY_UPGRADE_SMITHING_TEMPLATE.get());
        this.simpleItem((Item)ModItems.GOLDEN_NECKLACE.get());
        this.simpleItem((Item)ModItems.TOPAZ_NECKLACE.get());
        this.simpleItem((Item)ModItems.SAPPHIRE_NECKLACE.get());
        this.simpleItem((Item)ModItems.RUBY_NECKLACE.get());
        this.simpleItem((Item)ModItems.GEM_NECKLACE.get());
        this.simpleItem((Item)ModItems.GOLDEN_RING.get());
        this.simpleItem((Item)ModItems.TOPAZ_RING.get());
        this.simpleItem((Item)ModItems.SAPPHIRE_RING.get());
        this.simpleItem((Item)ModItems.RUBY_RING.get());
        this.simpleItem((Item)ModItems.GEM_RING.get());
        this.simpleItemEmissive((Item)ModItems.ENDER_MATTER.get());
        this.simpleItemEmissive((Item)ModItems.DRAGONYX_INGOT.get());
        this.simpleItemEmissive((Item)ModItems.DRAGONYX_HORSE_ARMOR.get());
        this.simpleItemEmissive((Item)ModItems.DRAGONYX_UPGRADE_SMITHING_TEMPLATE.get());
        this.handheldItem((Item)ModItems.TOPAZ_SWORD.get());
        this.handheldItem((Item)ModItems.TOPAZ_PICKAXE.get());
        this.handheldItem((Item)ModItems.TOPAZ_AXE.get());
        this.handheldItem((Item)ModItems.TOPAZ_SHOVEL.get());
        this.handheldItem((Item)ModItems.TOPAZ_HOE.get());
        this.handheldItem((Item)ModItems.SAPPHIRE_SWORD.get());
        this.handheldItem((Item)ModItems.SAPPHIRE_PICKAXE.get());
        this.handheldItem((Item)ModItems.SAPPHIRE_AXE.get());
        this.handheldItem((Item)ModItems.SAPPHIRE_SHOVEL.get());
        this.handheldItem((Item)ModItems.SAPPHIRE_HOE.get());
        this.handheldItem((Item)ModItems.RUBY_SWORD.get());
        this.handheldItem((Item)ModItems.RUBY_PICKAXE.get());
        this.handheldItem((Item)ModItems.RUBY_AXE.get());
        this.handheldItem((Item)ModItems.RUBY_SHOVEL.get());
        this.handheldItem((Item)ModItems.RUBY_HOE.get());
        this.handheldItem((Item)ModItems.EMERALD_SWORD.get());
        this.handheldItem((Item)ModItems.EMERALD_PICKAXE.get());
        this.handheldItem((Item)ModItems.EMERALD_AXE.get());
        this.handheldItem((Item)ModItems.EMERALD_SHOVEL.get());
        this.handheldItem((Item)ModItems.EMERALD_HOE.get());
        this.handheldItemEmissive((Item)ModItems.DRAGONYX_SWORD.get());
        this.handheldItemEmissive((Item)ModItems.DRAGONYX_PICKAXE.get());
        this.handheldItemEmissive((Item)ModItems.DRAGONYX_AXE.get());
        this.handheldItemEmissive((Item)ModItems.DRAGONYX_SHOVEL.get());
        this.handheldItemEmissive((Item)ModItems.DRAGONYX_HOE.get());
        this.trimmedArmorItem((Item)ModItems.TOPAZ_HELMET.get());
        this.trimmedArmorItem((Item)ModItems.TOPAZ_CHESTPLATE.get());
        this.trimmedArmorItem((Item)ModItems.TOPAZ_LEGGINGS.get());
        this.trimmedArmorItem((Item)ModItems.TOPAZ_BOOTS.get());
        this.trimmedArmorItem((Item)ModItems.SAPPHIRE_HELMET.get());
        this.trimmedArmorItem((Item)ModItems.SAPPHIRE_CHESTPLATE.get());
        this.trimmedArmorItem((Item)ModItems.SAPPHIRE_LEGGINGS.get());
        this.trimmedArmorItem((Item)ModItems.SAPPHIRE_BOOTS.get());
        this.trimmedArmorItem((Item)ModItems.RUBY_HELMET.get());
        this.trimmedArmorItem((Item)ModItems.RUBY_CHESTPLATE.get());
        this.trimmedArmorItem((Item)ModItems.RUBY_LEGGINGS.get());
        this.trimmedArmorItem((Item)ModItems.RUBY_BOOTS.get());
        this.trimmedArmorItem((Item)ModItems.EMERALD_HELMET.get());
        this.trimmedArmorItem((Item)ModItems.EMERALD_CHESTPLATE.get());
        this.trimmedArmorItem((Item)ModItems.EMERALD_LEGGINGS.get());
        this.trimmedArmorItem((Item)ModItems.EMERALD_BOOTS.get());
        this.trimmedArmorItemEmissive((Item)ModItems.DRAGONYX_HELMET.get());
        this.trimmedArmorItemEmissive((Item)ModItems.DRAGONYX_CHESTPLATE.get());
        this.trimmedArmorItemEmissive((Item)ModItems.DRAGONYX_LEGGINGS.get());
        this.trimmedArmorItemEmissive((Item)ModItems.DRAGONYX_BOOTS.get());
        this.bowItem((Item)ModItems.IRON_BOW.get());
        this.bowItem((Item)ModItems.GOLDEN_BOW.get());
        this.bowItem((Item)ModItems.DIAMOND_BOW.get());
        this.bowItem((Item)ModItems.NETHERITE_BOW.get());
        this.bowItem((Item)ModItems.TOPAZ_BOW.get());
        this.bowItem((Item)ModItems.SAPPHIRE_BOW.get());
        this.bowItem((Item)ModItems.RUBY_BOW.get());
        this.bowItem((Item)ModItems.EMERALD_BOW.get());
        this.bowItemEmissive((Item)ModItems.DRAGONYX_BOW.get());
        this.crossbowItem((Item)ModItems.IRON_CROSSBOW.get());
        this.crossbowItem((Item)ModItems.GOLDEN_CROSSBOW.get());
        this.crossbowItem((Item)ModItems.DIAMOND_CROSSBOW.get());
        this.crossbowItem((Item)ModItems.NETHERITE_CROSSBOW.get());
        this.crossbowItem((Item)ModItems.TOPAZ_CROSSBOW.get());
        this.crossbowItem((Item)ModItems.SAPPHIRE_CROSSBOW.get());
        this.crossbowItem((Item)ModItems.RUBY_CROSSBOW.get());
        this.crossbowItem((Item)ModItems.EMERALD_CROSSBOW.get());
        this.crossbowItemEmissive((Item)ModItems.DRAGONYX_CROSSBOW.get());
        this.shieldItem((Item)ModItems.IRON_SHIELD.get(), this.mcLoc("block/iron_block"));
        this.shieldItem((Item)ModItems.GOLDEN_SHIELD.get(), this.mcLoc("block/gold_block"));
        this.shieldItem((Item)ModItems.DIAMOND_SHIELD.get(), this.mcLoc("block/diamond_block"));
        this.shieldItem((Item)ModItems.NETHERITE_SHIELD.get(), this.mcLoc("block/netherite_block"));
        this.shieldItem((Item)ModItems.TOPAZ_SHIELD.get(), this.modLoc("block/topaz_block"));
        this.shieldItem((Item)ModItems.SAPPHIRE_SHIELD.get(), this.modLoc("block/sapphire_block"));
        this.shieldItem((Item)ModItems.RUBY_SHIELD.get(), this.modLoc("block/ruby_block"));
        this.shieldItem((Item)ModItems.EMERALD_SHIELD.get(), this.mcLoc("block/emerald_block"));
        this.shieldItemEmissive((Item)ModItems.DRAGONYX_SHIELD.get(), this.modLoc("block/onyx_block"));
    }

    private void emissiveItem(Item item, String connector, String parent, String path) {
        ((ItemLayerModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(Gems.getPath(item) + connector, this.mcLoc(parent))).texture("layer0", this.modLoc(path))).texture("layer1", this.modLoc(path + "_overlay"))).customLoader(ItemLayerModelBuilder::begin)).emissive(15, 15, new int[]{1}).end();
    }

    private void simpleItem(Item item) {
        ((ItemModelBuilder)this.withExistingParent(Gems.getPath(item), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + Gems.getPath(item)));
    }

    private void simpleItemEmissive(Item item) {
        this.emissiveItem(item, "", "item/generated", "item/" + Gems.getPath(item));
    }

    private void handheldItem(Item item) {
        ((ItemModelBuilder)this.withExistingParent(Gems.getPath(item), this.mcLoc("item/handheld"))).texture("layer0", this.modLoc("item/" + Gems.getPath(item)));
    }

    private void handheldItemEmissive(Item item) {
        this.emissiveItem(item, "", "item/handheld", "item/" + Gems.getPath(item));
    }

    private void trimmedArmorItem(Item item) {
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            TRIM_MATERIALS.forEach((trimMaterial, value) -> {
                String armorType = switch (armorItem.m_40402_()) {
                    case EquipmentSlot.HEAD -> "helmet";
                    case EquipmentSlot.CHEST -> "chestplate";
                    case EquipmentSlot.LEGS -> "leggings";
                    case EquipmentSlot.FEET -> "boots";
                    default -> "";
                };
                this.existingFileHelper.trackGenerated(this.mcLoc("trims/items/" + armorType + "_trim_" + trimMaterial.m_135782_().m_135815_()), PackType.CLIENT_RESOURCES, ".png", "textures");
                ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("item/" + armorItem + "_" + trimMaterial.m_135782_().m_135815_() + "_trim")).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.modLoc("item/" + armorItem))).texture("layer1", this.mcLoc("trims/items/" + armorType + "_trim_" + trimMaterial.m_135782_().m_135815_()));
                ((ItemModelBuilder)this.withExistingParent(item.toString(), this.mcLoc("item/generated"))).override().model((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("item/" + armorItem + "_" + trimMaterial.m_135782_().m_135815_() + "_trim"))).predicate(this.mcLoc("trim_type"), value.floatValue()).end().texture("layer0", this.modLoc("item/" + item));
            });
        }
    }

    private void trimmedArmorItemEmissive(Item item) {
        this.trimmedArmorItem(item);
        ((ItemLayerModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.toString(), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + item))).texture("layer1", this.modLoc("item/" + item + "_overlay"))).customLoader(ItemLayerModelBuilder::begin)).emissive(15, 15, new int[]{1}).end();
    }

    private void bowItem(Item item) {
        ((ItemModelBuilder)this.withExistingParent(Gems.getPath(item) + "_pulling_0", this.mcLoc("item/bow"))).texture("layer0", this.modLoc("item/" + Gems.getPath(item) + "_pulling_0"));
        ((ItemModelBuilder)this.withExistingParent(Gems.getPath(item) + "_pulling_1", this.mcLoc("item/bow"))).texture("layer0", this.modLoc("item/" + Gems.getPath(item) + "_pulling_1"));
        ((ItemModelBuilder)this.withExistingParent(Gems.getPath(item) + "_pulling_2", this.mcLoc("item/bow"))).texture("layer0", this.modLoc("item/" + Gems.getPath(item) + "_pulling_2"));
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(Gems.getPath(item), this.mcLoc("item/bow"))).texture("layer0", this.modLoc("item/" + Gems.getPath(item)))).override().predicate(this.mcLoc("pulling"), 1.0f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + Gems.getPath(item) + "_pulling_0"))).end().override().predicate(this.mcLoc("pulling"), 1.0f).predicate(this.mcLoc("pull"), 0.65f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + Gems.getPath(item) + "_pulling_1"))).end().override().predicate(this.mcLoc("pulling"), 1.0f).predicate(this.mcLoc("pull"), 0.9f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + Gems.getPath(item) + "_pulling_2"))).end();
    }

    private void bowItemEmissive(Item item) {
        this.bowItem(item);
        this.emissiveItem(item, "", "item/bow", "item/" + Gems.getPath(item));
        this.emissiveItem(item, "_pulling_0", "item/bow", "item/" + Gems.getPath(item) + "_pulling_0");
        this.emissiveItem(item, "_pulling_1", "item/bow", "item/" + Gems.getPath(item) + "_pulling_1");
        this.emissiveItem(item, "_pulling_2", "item/bow", "item/" + Gems.getPath(item) + "_pulling_2");
    }

    private void crossbowItem(Item item) {
        ((ItemModelBuilder)this.withExistingParent(Gems.getPath(item) + "_pulling_0", this.mcLoc("item/crossbow"))).texture("layer0", this.modLoc("item/" + Gems.getPath(item) + "_pulling_0"));
        ((ItemModelBuilder)this.withExistingParent(Gems.getPath(item) + "_pulling_1", this.mcLoc("item/crossbow"))).texture("layer0", this.modLoc("item/" + Gems.getPath(item) + "_pulling_1"));
        ((ItemModelBuilder)this.withExistingParent(Gems.getPath(item) + "_pulling_2", this.mcLoc("item/crossbow"))).texture("layer0", this.modLoc("item/" + Gems.getPath(item) + "_pulling_2"));
        ((ItemModelBuilder)this.withExistingParent(Gems.getPath(item) + "_arrow", this.mcLoc("item/crossbow"))).texture("layer0", this.modLoc("item/" + Gems.getPath(item) + "_arrow"));
        ((ItemModelBuilder)this.withExistingParent(Gems.getPath(item) + "_firework", this.mcLoc("item/crossbow"))).texture("layer0", this.modLoc("item/" + Gems.getPath(item) + "_firework"));
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(Gems.getPath(item), this.mcLoc("item/crossbow"))).texture("layer0", this.modLoc("item/" + Gems.getPath(item) + "_standby"))).override().predicate(this.mcLoc("pulling"), 1.0f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + Gems.getPath(item) + "_pulling_0"))).end().override().predicate(this.mcLoc("pulling"), 1.0f).predicate(this.mcLoc("pull"), 0.58f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + Gems.getPath(item) + "_pulling_1"))).end().override().predicate(this.mcLoc("pulling"), 1.0f).predicate(this.mcLoc("pull"), 1.0f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + Gems.getPath(item) + "_pulling_2"))).end().override().predicate(this.mcLoc("charged"), 1.0f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + Gems.getPath(item) + "_arrow"))).end().override().predicate(this.mcLoc("charged"), 1.0f).predicate(this.mcLoc("firework"), 1.0f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + Gems.getPath(item) + "_firework"))).end();
    }

    private void crossbowItemEmissive(Item item) {
        this.crossbowItem(item);
        this.emissiveItem(item, "", "item/crossbow", "item/" + Gems.getPath(item) + "_standby");
        this.emissiveItem(item, "_pulling_0", "item/crossbow", "item/" + Gems.getPath(item) + "_pulling_0");
        this.emissiveItem(item, "_pulling_1", "item/crossbow", "item/" + Gems.getPath(item) + "_pulling_1");
        this.emissiveItem(item, "_pulling_2", "item/crossbow", "item/" + Gems.getPath(item) + "_pulling_2");
        this.emissiveItem(item, "_arrow", "item/crossbow", "item/" + Gems.getPath(item) + "_arrow");
        this.emissiveItem(item, "_firework", "item/crossbow", "item/" + Gems.getPath(item) + "_firework");
    }

    private void shieldItem(Item item, ResourceLocation particle) {
        ((ItemModelBuilder)this.withExistingParent(Gems.getPath(item) + "_blocking", this.mcLoc("item/shield_blocking"))).texture("particle", particle);
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(Gems.getPath(item), this.mcLoc("item/shield"))).texture("particle", particle)).override().predicate(this.mcLoc("blocking"), 1.0f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + Gems.getPath(item) + "_blocking"))).end();
    }

    private void shieldItemEmissive(Item item, ResourceLocation particle) {
        this.shieldItem(item, particle);
    }

    static {
        TRIM_MATERIALS.put(ModTrimMaterials.TOPAZ, Float.valueOf(0.01f));
        TRIM_MATERIALS.put(ModTrimMaterials.SAPPHIRE, Float.valueOf(0.02f));
        TRIM_MATERIALS.put(ModTrimMaterials.RUBY, Float.valueOf(0.03f));
        TRIM_MATERIALS.put(ModTrimMaterials.ONYX, Float.valueOf(0.04f));
        TRIM_MATERIALS.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265905_, Float.valueOf(0.1f));
        TRIM_MATERIALS.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266000_, Float.valueOf(0.2f));
        TRIM_MATERIALS.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265896_, Float.valueOf(0.3f));
        TRIM_MATERIALS.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265870_, Float.valueOf(0.4f));
        TRIM_MATERIALS.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265969_, Float.valueOf(0.5f));
        TRIM_MATERIALS.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265937_, Float.valueOf(0.6f));
        TRIM_MATERIALS.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266071_, Float.valueOf(0.7f));
        TRIM_MATERIALS.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266027_, Float.valueOf(0.8f));
        TRIM_MATERIALS.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265981_, Float.valueOf(0.9f));
        TRIM_MATERIALS.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265872_, Float.valueOf(1.0f));
    }
}

