/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced.world.structure.prefabs;

import com.barion.dungeons_enhanced.DEUtil;
import com.barion.dungeons_enhanced.registry.DEStructures;
import com.barion.dungeons_enhanced.world.structure.prefabs.DEBaseStructure;
import com.barion.dungeons_enhanced.world.structure.prefabs.utils.DEPieceAssembler;
import com.barion.dungeons_enhanced.world.structure.prefabs.utils.DEStructureTemplates;
import com.legacy.structure_gel.api.registry.registrar.Registrar;
import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class DEUndergroundStructure
extends DEBaseStructure {
    public static final String ID_DUNGEON_VARIANT = "dungeon_variant";
    public static final Codec<DEUndergroundStructure> CODEC_DUNGEON_VARIANT = DEUndergroundStructure.m_226607_(DEUndergroundStructure::DungeonVariant);

    public static DEUndergroundStructure DungeonVariant(Structure.StructureSettings settings) {
        return new DEUndergroundStructure(settings, DEUtil.pieceBuilder().add("dungeon_variant/zombie").add("dungeon_variant/skeleton").add("dungeon_variant/spider").add("dungeon_variant/special").build(), () -> DEStructures.DUNGEON_VARIANT.getType());
    }

    protected DEUndergroundStructure(Structure.StructureSettings settings, DEStructureTemplates variants, Supplier<StructureType<?>> type) {
        super(settings, variants, type);
    }

    @Override
    @Nonnull
    public Optional<Structure.GenerationStub> m_214086_(@Nonnull Structure.GenerationContext context) {
        int maxY;
        BlockPos rawPos = DEUtil.chunkPosToBlockPosFromHeightMap(context.f_226628_(), context.f_226622_(), Heightmap.Types.OCEAN_FLOOR_WG, context.f_226629_(), context.f_226624_());
        if (rawPos.m_123342_() < 0) {
            return Optional.empty();
        }
        int minY = context.f_226622_().m_142062_() + 8;
        int y = maxY = rawPos.m_123342_() - 24;
        if (maxY > minY) {
            y = minY + context.f_226626_().m_188503_(maxY - minY);
        }
        DEStructureTemplates.Template template = this._templates.getRandom((RandomSource)context.f_226626_());
        BlockPos pos = rawPos.m_175288_(y).m_6630_(template.yOffset);
        return DEUndergroundStructure.at(pos, builder -> DEUndergroundStructure.generatePieces(builder, pos, template, Rotation.m_221990_((RandomSource)context.f_226626_()), context, DEUndergroundStructure::assemble));
    }

    protected static void assemble(DEPieceAssembler.Context context) {
        context.piecesBuilder().m_142679_((StructurePiece)new Piece(context.structureManager(), context.piece(), context.pos(), context.rotation()));
    }

    public static class Piece
    extends DEBaseStructure.Piece {
        public Piece(StructureTemplateManager structureManager, ResourceLocation templateName, BlockPos pos, Rotation rotation) {
            super((Registrar.Static<StructurePieceType>)DEStructures.DUNGEON_VARIANT.getPieceType(), structureManager, templateName, pos, rotation);
        }

        public Piece(StructurePieceSerializationContext serializationContext, CompoundTag nbt) {
            super((Registrar.Static<StructurePieceType>)DEStructures.DUNGEON_VARIANT.getPieceType(), serializationContext, nbt);
        }
    }
}

