/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.common.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.povstalec.stellarview.common.util.SpaceCoords;
import net.povstalec.stellarview.common.util.SphericalCoords;
import org.joml.Vector3f;

public class StellarCoordinates {
    public static double sphericalR(double x, double y, double z) {
        return Math.sqrt(x * x + y * y + z * z);
    }

    public static double sphericalTheta(double x, double y, double z) {
        return Math.atan2(x, z);
    }

    public static double sphericalPhi(double x, double y, double z) {
        double xzLength = Math.sqrt(x * x + z * z);
        return Math.atan2(xzLength, y);
    }

    public static Vector3f cartesianToSpherical(Vector3f cartesianCoordinates) {
        float x = cartesianCoordinates.x;
        float y = cartesianCoordinates.y;
        float z = cartesianCoordinates.z;
        return new Vector3f((float)StellarCoordinates.sphericalR(x, y, z), (float)StellarCoordinates.sphericalTheta(x, y, z), (float)StellarCoordinates.sphericalPhi(x, y, z));
    }

    public static double cartesianX(double r, double theta, double phi) {
        return r * Math.sin(phi) * Math.sin(theta);
    }

    public static double cartesianY(double r, double theta, double phi) {
        return r * Math.cos(phi);
    }

    public static double cartesianZ(double r, double theta, double phi) {
        return r * Math.sin(phi) * Math.cos(theta);
    }

    public static Vector3f sphericalToCartesian(Vector3f sphericalCoordinates) {
        float r = sphericalCoordinates.x;
        float theta = sphericalCoordinates.y;
        float phi = sphericalCoordinates.z;
        return new Vector3f((float)StellarCoordinates.cartesianX(r, theta, phi), (float)StellarCoordinates.cartesianY(r, theta, phi), (float)StellarCoordinates.cartesianZ(r, theta, phi));
    }

    public static double[] moveSpherical(double offsetX, double offsetY, double r, double theta, double phi) {
        double x = StellarCoordinates.cartesianX(r, theta, phi);
        double y = StellarCoordinates.cartesianY(r, theta, phi);
        double z = StellarCoordinates.cartesianZ(r, theta, phi);
        return new double[]{x += -offsetY * Math.cos(phi) * Math.sin(theta) - offsetX * Math.cos(theta), y += offsetY * Math.sin(phi), z += -offsetY * Math.cos(phi) * Math.cos(theta) + offsetX * Math.sin(theta)};
    }

    public static Vector3f placeOnSphere(float offsetX, float offsetY, float r, double theta, double phi, double rotation) {
        double x = StellarCoordinates.cartesianX(r, theta, phi);
        double y = StellarCoordinates.cartesianY(r, theta, phi);
        double z = StellarCoordinates.cartesianZ(r, theta, phi);
        double polarR = Math.sqrt(offsetX * offsetX + offsetY * offsetY);
        double polarPhi = Math.atan2(offsetY, offsetX);
        double polarX = polarR * Math.cos(polarPhi += rotation);
        double polarY = polarR * Math.sin(polarPhi);
        return new Vector3f((float)(x += -polarY * Math.cos(phi) * Math.sin(theta) - polarX * Math.cos(theta)), (float)(y += polarY * Math.sin(phi)), (float)(z += -polarY * Math.cos(phi) * Math.cos(theta) + polarX * Math.sin(theta)));
    }

    public static Vector3f placeOnSphere(float offsetX, float offsetY, SphericalCoords sphericalCoords, double rotation) {
        Vector3f cartesian = sphericalCoords.toCartesianF();
        double polarR = Math.sqrt(offsetX * offsetX + offsetY * offsetY);
        double polarPhi = Math.atan2(offsetY, offsetX);
        double polarX = polarR * Math.cos(polarPhi += rotation);
        double polarY = polarR * Math.sin(polarPhi);
        cartesian.x = (float)((double)cartesian.x + (-polarY * Math.cos(sphericalCoords.phi) * Math.sin(sphericalCoords.theta) - polarX * Math.cos(sphericalCoords.theta)));
        cartesian.y = (float)((double)cartesian.y + polarY * Math.sin(sphericalCoords.phi));
        cartesian.z = (float)((double)cartesian.z + (-polarY * Math.cos(sphericalCoords.phi) * Math.cos(sphericalCoords.theta) + polarX * Math.sin(sphericalCoords.theta)));
        return cartesian;
    }

    public static double spiralR(double r, double phi, double beta) {
        return r * (phi + beta);
    }

    public static double elipticalR(double a, double b, double phi) {
        return a * b / Math.sqrt(b * Math.pow(Math.cos(phi), 2.0) + a * Math.pow(Math.sin(phi), 2.0));
    }

    public static Vector3f addVectors(Vector3f vector1, Vector3f vector2) {
        return new Vector3f(vector1.x + vector2.x, vector1.y + vector2.y, vector1.z + vector2.z);
    }

    public static Vector3f subtractVectors(Vector3f vector1, Vector3f vector2) {
        return new Vector3f(vector1.x - vector2.x, vector1.y - vector2.y, vector1.z - vector2.z);
    }

    public static Vector3f relativeVector(Vector3f vector1, Vector3f vector2) {
        return StellarCoordinates.subtractVectors(vector1, vector2);
    }

    public static Vector3f absoluteVector(Vector3f vector1, Vector3f vector2) {
        return StellarCoordinates.addVectors(vector1, vector2);
    }

    public static class Galactic {
        public final double galacticLongtitude;
        public final double galacticLatitude;
        public final SpaceCoords.SpaceDistance distance;

        public Galactic(double galacticLongtitude, double galacticLatitude, SpaceCoords.SpaceDistance distance) {
            this.galacticLongtitude = galacticLongtitude;
            this.galacticLatitude = galacticLatitude;
            this.distance = distance;
        }

        public SpaceCoords toSpaceCoords() {
            double xProj = Math.sin(this.galacticLongtitude) * Math.cos(this.galacticLatitude);
            double yProj = Math.sin(this.galacticLatitude);
            double zProj = Math.cos(this.galacticLongtitude) * Math.cos(this.galacticLatitude);
            return new SpaceCoords(this.distance.mul(xProj, false), this.distance.mul(yProj, false), this.distance.mul(zProj, false));
        }

        public String toString() {
            return "{Long: " + Math.toDegrees(this.galacticLongtitude) + "\u00b0 Lat: " + Math.toDegrees(this.galacticLatitude) + "\u00b0 Dist: " + this.distance.toString() + "}";
        }
    }

    public static class Equatorial {
        public static final String RIGHT_ASCENSION = "right_ascension";
        public static final String DECLINATION = "declination";
        public static final String DISTNACE = "distance";
        public static final double RIGHT_ASCENSION_NGP = Math.toRadians(192.85948);
        public static final double DECLINATION_NGP = Math.toRadians(27.12825);
        public static final double L_NCP = Math.toRadians(122.93192);
        public final RightAscension rightAscension;
        public final Declination declination;
        public final SpaceCoords.SpaceDistance distance;
        public static final Codec<Equatorial> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RightAscension.CODEC.fieldOf(RIGHT_ASCENSION).forGetter(equatorial -> equatorial.rightAscension), (App)Declination.CODEC.fieldOf(DECLINATION).forGetter(equatorial -> equatorial.declination), (App)SpaceCoords.SpaceDistance.CODEC.fieldOf(DISTNACE).forGetter(equatorial -> equatorial.distance)).apply((Applicative)instance, Equatorial::new));

        public Equatorial(RightAscension rightAscension, Declination declination, SpaceCoords.SpaceDistance distance) {
            this.rightAscension = rightAscension;
            this.declination = declination;
            this.distance = distance;
        }

        public Galactic toGalactic() {
            return Equatorial.toGalactic(this.rightAscension.radians, this.declination.radians, this.distance);
        }

        public static Galactic toGalactic(double rightAscension, double declination, SpaceCoords.SpaceDistance distance) {
            double sinB = Math.sin(DECLINATION_NGP) * Math.sin(declination) + Math.cos(DECLINATION_NGP) * Math.cos(declination) * Math.cos(rightAscension - RIGHT_ASCENSION_NGP);
            double galacticLatitude = Math.asin(sinB);
            double x1 = Math.cos(declination) * Math.sin(rightAscension - RIGHT_ASCENSION_NGP);
            double x2 = (Math.sin(declination) - Math.sin(DECLINATION_NGP) * galacticLatitude) / Math.cos(DECLINATION_NGP);
            double galacticLongtitude = L_NCP - Math.atan2(x1, x2);
            return new Galactic(galacticLongtitude, galacticLatitude, distance);
        }

        public String toString() {
            return "{RA: " + this.rightAscension.toString() + " Dec: " + this.declination.toString() + " Dist: " + this.distance.toString() + "}";
        }
    }

    public static class Declination {
        public static final String DEGREES = "degrees";
        public static final String MINUTES = "minutes";
        public static final String SECONDS = "seconds";
        public final double degrees;
        public final double minutes;
        public final double seconds;
        public final double radians;
        public static final Codec<Declination> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.doubleRange((double)-180.0, (double)180.0).optionalFieldOf(DEGREES, (Object)0.0).forGetter(declination -> declination.degrees), (App)Codec.doubleRange((double)-60.0, (double)60.0).optionalFieldOf(MINUTES, (Object)0.0).forGetter(declination -> declination.minutes), (App)Codec.doubleRange((double)-60.0, (double)60.0).optionalFieldOf(SECONDS, (Object)0.0).forGetter(declination -> declination.seconds)).apply((Applicative)instance, Declination::new));

        public Declination(double degrees, double minutes, double seconds) {
            this.degrees = degrees;
            if (Declination.isNegative(degrees)) {
                this.minutes = -minutes;
                this.seconds = -seconds;
            } else {
                this.minutes = minutes;
                this.seconds = seconds;
            }
            this.radians = Declination.toDeclination(this.degrees, this.minutes, this.seconds);
        }

        public static boolean isNegative(double degrees) {
            return Double.doubleToRawLongBits(degrees) < 0L;
        }

        public static double toDeclination(double degrees, double minutes, double seconds) {
            return Math.toRadians(degrees + minutes / 60.0 + seconds / 3600.0);
        }

        public String toString() {
            return "[" + this.degrees + "\u00b0 " + this.minutes + "' " + this.seconds + "\"]";
        }
    }

    public static class RightAscension {
        public static final String HOURS = "hours";
        public static final String MINUTES = "minutes";
        public static final String SECONDS = "seconds";
        public final double hours;
        public final double minutes;
        public final double seconds;
        public final double radians;
        public static final Codec<RightAscension> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.doubleRange((double)0.0, (double)24.0).optionalFieldOf(HOURS, (Object)0.0).forGetter(rightAscension -> rightAscension.hours), (App)Codec.doubleRange((double)0.0, (double)60.0).optionalFieldOf(MINUTES, (Object)0.0).forGetter(rightAscension -> rightAscension.minutes), (App)Codec.doubleRange((double)0.0, (double)60.0).optionalFieldOf(SECONDS, (Object)0.0).forGetter(rightAscension -> rightAscension.seconds)).apply((Applicative)instance, RightAscension::new));

        public RightAscension(double hours, double minutes, double seconds) {
            this.hours = hours;
            this.minutes = minutes;
            this.seconds = seconds;
            this.radians = RightAscension.toRightAscension(hours, minutes, seconds);
        }

        public static double toRightAscension(double hours, double minutes, double seconds) {
            return Math.toRadians(360.0 * (hours / 24.0) + 360.0 * (minutes / 1440.0) + 360.0 * (seconds / 86400.0));
        }

        public String toString() {
            return "[" + this.hours + "h " + this.minutes + "m " + this.seconds + "s]";
        }
    }
}

