/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GameRenderer;
import net.povstalec.stellarview.api.common.space_objects.StarLike;
import net.povstalec.stellarview.api.common.space_objects.resourcepack.Constellation;
import net.povstalec.stellarview.api.common.space_objects.resourcepack.StarField;
import net.povstalec.stellarview.client.render.SpaceRenderer;
import net.povstalec.stellarview.client.render.shader.StellarViewShaders;
import net.povstalec.stellarview.client.render.shader.StellarViewVertexFormat;
import net.povstalec.stellarview.client.render.shader.VertexOrder;
import net.povstalec.stellarview.client.util.CelestialBuffer;
import net.povstalec.stellarview.client.util.CelestialInstancedBuffer;
import net.povstalec.stellarview.common.config.GeneralConfig;
import net.povstalec.stellarview.common.util.Color;
import net.povstalec.stellarview.common.util.SpaceCoords;
import org.joml.Matrix4f;

public abstract class StarData {
    public static final float DEFAULT_DISTANCE = 100.0f;
    public static final float MIN_STAR_SIZE = 0.02f;
    public static final float MIN_TEX_STAR_SIZE = 0.08f;
    public static final int HEIGHT_OFFSET = 0;
    public static final int WIDTH_OFFSET = 4;
    public static final int STAR_SIZE_OFFSET = 8;
    public static final int DISTANCE_OFFSET = 12;
    public static final int INSTANCE_SIZE = 10;
    private LOD lod1;
    private LOD lod2;
    private LOD lod3;

    private LOD getLOD(StarField.LevelOfDetail lod) {
        return switch (lod) {
            default -> throw new IncompatibleClassChangeError();
            case StarField.LevelOfDetail.LOD1 -> this.lod1;
            case StarField.LevelOfDetail.LOD2 -> this.lod2;
            case StarField.LevelOfDetail.LOD3 -> this.lod3;
        };
    }

    public void reset() {
        if (this.lod1 != null) {
            this.lod1.reset();
        }
        if (this.lod2 != null) {
            this.lod2.reset();
        }
        if (this.lod3 != null) {
            this.lod3.reset();
        }
    }

    public void renderStars(StarField.LevelOfDetail levelOfDetail, Matrix4f pose, Matrix4f projectionMatrix, SpaceCoords difference, boolean isStatic, boolean hasTexture) {
        if (!isStatic && GeneralConfig.instancing.get() && CelestialInstancedBuffer.INSTANCING_PREREQUISITES) {
            switch (levelOfDetail) {
                case LOD3: {
                    if (this.lod3 == null) {
                        this.lod3 = this.newStars(StarField.LevelOfDetail.LOD3);
                    }
                    this.lod3.renderInstancedStarBuffer(pose, projectionMatrix, difference, hasTexture);
                }
                case LOD2: {
                    if (this.lod2 == null) {
                        this.lod2 = this.newStars(StarField.LevelOfDetail.LOD2);
                    }
                    this.lod2.renderInstancedStarBuffer(pose, projectionMatrix, difference, hasTexture);
                }
                case LOD1: {
                    if (this.lod1 == null) {
                        this.lod1 = this.newStars(StarField.LevelOfDetail.LOD1);
                    }
                    this.lod1.renderInstancedStarBuffer(pose, projectionMatrix, difference, hasTexture);
                }
            }
        } else {
            switch (levelOfDetail) {
                case LOD3: {
                    if (this.lod3 == null) {
                        this.lod3 = this.newStars(StarField.LevelOfDetail.LOD3);
                    }
                    this.lod3.renderStarBuffer(pose, projectionMatrix, difference, isStatic, hasTexture);
                }
                case LOD2: {
                    if (this.lod2 == null) {
                        this.lod2 = this.newStars(StarField.LevelOfDetail.LOD2);
                    }
                    this.lod2.renderStarBuffer(pose, projectionMatrix, difference, isStatic, hasTexture);
                }
                case LOD1: {
                    if (this.lod1 == null) {
                        this.lod1 = this.newStars(StarField.LevelOfDetail.LOD1);
                    }
                    this.lod1.renderStarBuffer(pose, projectionMatrix, difference, isStatic, hasTexture);
                }
            }
        }
    }

    protected abstract LOD newStars(StarField.LevelOfDetail var1);

    public static class LOD {
        @Nullable
        private CelestialBuffer starBuffer;
        @Nullable
        private CelestialInstancedBuffer instancedStarBuffer;
        private double[][] starCoords;
        private double[] starSizes;
        private double[] starDistances;
        private short[][] starRGBA;
        private double[] starRotations;
        private int stars;

        public LOD(int stars) {
            this.starCoords = new double[stars][3];
            this.starSizes = new double[stars];
            this.starDistances = new double[stars];
            this.starRotations = new double[stars];
            this.starRGBA = new short[stars][4];
            this.stars = 0;
        }

        public void reset() {
            if (this.starBuffer != null) {
                this.starBuffer.close();
                this.starBuffer = null;
            }
            if (this.instancedStarBuffer != null) {
                this.instancedStarBuffer.close();
                this.instancedStarBuffer = null;
            }
        }

        public void newStar(Constellation.StarDefinition starDefinition, SpaceCoords offsetCoords) {
            this.starCoords[this.stars][0] = starDefinition.coords().x().toLy() - offsetCoords.x().toLy();
            this.starCoords[this.stars][1] = starDefinition.coords().y().toLy() - offsetCoords.y().toLy();
            this.starCoords[this.stars][2] = starDefinition.coords().z().toLy() - offsetCoords.z().toLy();
            this.starSizes[this.stars] = starDefinition.size();
            this.starDistances[this.stars] = starDefinition.maxVisibleDistance();
            this.starRGBA[this.stars] = new short[]{(short)starDefinition.rgb().red(), (short)starDefinition.rgb().green(), (short)starDefinition.rgb().blue(), starDefinition.brightness()};
            this.starRotations[this.stars] = starDefinition.rotation();
            ++this.stars;
        }

        public void newStar(StarLike.StarType starType, Random random, double x, double y, double z) {
            this.starCoords[this.stars][0] = x;
            this.starCoords[this.stars][1] = y;
            this.starCoords[this.stars][2] = z;
            this.starDistances[this.stars] = starType.getMaxVisibleDistance();
            short alpha = starType.randomBrightness(random);
            Color.IntRGB rgb = starType.getRGB();
            this.starSizes[this.stars] = starType.randomSize(random);
            this.starRGBA[this.stars] = new short[]{(short)rgb.red(), (short)rgb.green(), (short)rgb.blue(), alpha};
            this.starRotations[this.stars] = random.nextDouble() * Math.PI * 2.0;
            ++this.stars;
        }

        public void createStar(BufferBuilder builder, boolean hasTexture, int i) {
            double sinRandom = Math.sin(this.starRotations[i]);
            double cosRandom = Math.cos(this.starRotations[i]);
            for (int j = 0; j < 4; ++j) {
                double aLocation = (j & 2) - 1;
                double bLocation = (j + 1 & 2) - 1;
                double height = aLocation * cosRandom - bLocation * sinRandom;
                double width = bLocation * cosRandom + aLocation * sinRandom;
                builder.m_5483_(this.starCoords[i][0], this.starCoords[i][1], this.starCoords[i][2]).m_6122_((int)this.starRGBA[i][0], (int)this.starRGBA[i][1], (int)this.starRGBA[i][2], (int)this.starRGBA[i][3]);
                builder.m_5832_(0, (float)height);
                builder.m_5832_(4, (float)width);
                builder.m_5832_(8, hasTexture ? (float)this.starSizes[i] * 4.0f : (float)this.starSizes[i]);
                builder.m_5832_(12, (float)this.starDistances[i]);
                builder.m_5751_();
                if (hasTexture) {
                    builder.m_7421_((float)(aLocation + 1.0) / 2.0f, (float)(bLocation + 1.0) / 2.0f);
                }
                builder.m_5752_();
            }
        }

        public float[] getInstancedStars(boolean hasTexture) {
            float[] instances = new float[this.stars * 10];
            for (int i = 0; i < this.stars; ++i) {
                instances[10 * i] = (float)this.starCoords[i][0];
                instances[10 * i + 1] = (float)this.starCoords[i][1];
                instances[10 * i + 2] = (float)this.starCoords[i][2];
                instances[10 * i + 3] = (float)this.starRGBA[i][0] / 255.0f;
                instances[10 * i + 4] = (float)this.starRGBA[i][1] / 255.0f;
                instances[10 * i + 5] = (float)this.starRGBA[i][2] / 255.0f;
                instances[10 * i + 6] = (float)this.starRGBA[i][3] / 255.0f;
                instances[10 * i + 7] = (float)this.starRotations[i];
                instances[10 * i + 8] = hasTexture ? (float)this.starSizes[i] * 4.0f : (float)this.starSizes[i];
                instances[10 * i + 9] = (float)this.starDistances[i];
            }
            return instances;
        }

        public BufferBuilder.RenderedBuffer getStarBuffer(BufferBuilder bufferBuilder, boolean hasTexture) {
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, hasTexture ? StellarViewVertexFormat.STAR_POS_COLOR_LY_TEX : StellarViewVertexFormat.STAR_POS_COLOR_LY);
            for (int i = 0; i < this.stars; ++i) {
                this.createStar(bufferBuilder, hasTexture, i);
            }
            return bufferBuilder.m_231175_();
        }

        private void renderStarBuffer(Matrix4f pose, Matrix4f projectionMatrix, SpaceCoords difference, boolean isStatic, boolean hasTexture) {
            if (this.stars == 0) {
                return;
            }
            if (this.starBuffer == null) {
                if (!SpaceRenderer.loadNewStars()) {
                    return;
                }
                this.starBuffer = new CelestialBuffer();
                Tesselator tesselator = Tesselator.m_85913_();
                BufferBuilder bufferBuilder = tesselator.m_85915_();
                RenderSystem.setShader(GameRenderer::m_172808_);
                BufferBuilder.RenderedBuffer bufferbuilder$renderedbuffer = isStatic ? this.getStaticStarBuffer(bufferBuilder, hasTexture, difference) : this.getStarBuffer(bufferBuilder, hasTexture);
                this.starBuffer.bind();
                this.starBuffer.upload(bufferbuilder$renderedbuffer);
                if (isStatic) {
                    this.starBuffer.drawWithShader(pose, projectionMatrix, hasTexture ? VertexOrder.texColorShader() : GameRenderer.m_172811_());
                } else {
                    this.starBuffer.drawWithShader(pose, projectionMatrix, difference, hasTexture ? StellarViewShaders.starTexShader() : StellarViewShaders.starShader());
                }
                CelestialBuffer.unbind();
                SpaceRenderer.loadedStars(this.stars);
            } else {
                this.starBuffer.bind();
                if (isStatic) {
                    this.starBuffer.drawWithShader(pose, projectionMatrix, hasTexture ? VertexOrder.texColorShader() : GameRenderer.m_172811_());
                } else {
                    this.starBuffer.drawWithShader(pose, projectionMatrix, difference, hasTexture ? StellarViewShaders.starTexShader() : StellarViewShaders.starShader());
                }
                CelestialBuffer.unbind();
            }
        }

        private void renderInstancedStarBuffer(Matrix4f pose, Matrix4f projectionMatrix, SpaceCoords difference, boolean hasTexture) {
            if (this.stars == 0) {
                return;
            }
            if (this.instancedStarBuffer == null) {
                if (!SpaceRenderer.loadNewStars()) {
                    return;
                }
                this.instancedStarBuffer = new CelestialInstancedBuffer();
                this.instancedStarBuffer.upload(this.getInstancedStars(hasTexture), hasTexture);
                SpaceRenderer.loadedStars(this.stars);
            }
            this.instancedStarBuffer.bind();
            this.instancedStarBuffer.drawWithShader(pose, projectionMatrix, difference, hasTexture ? StellarViewShaders.instancedStarTexShader() : StellarViewShaders.instancedStarShader(), this.stars);
            CelestialInstancedBuffer.unbind();
        }

        public BufferBuilder.RenderedBuffer getStaticStarBuffer(BufferBuilder bufferBuilder, boolean hasTexture, SpaceCoords difference) {
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, hasTexture ? VertexOrder.texColorFormat() : DefaultVertexFormat.f_85815_);
            for (int i = 0; i < this.stars; ++i) {
                this.createStaticStar(bufferBuilder, hasTexture, i, difference);
            }
            return bufferBuilder.m_231175_();
        }

        double clampStar(double starSize, double minStarSize, double distance) {
            if ((starSize -= starSize * distance / 1000000.0) < minStarSize) {
                return minStarSize;
            }
            return starSize;
        }

        private void createStaticStar(BufferBuilder builder, boolean hasTexture, int i, SpaceCoords difference) {
            double z;
            double y;
            double x = this.starCoords[i][0] - difference.x().toLy();
            double distance = Math.sqrt(x * x + (y = this.starCoords[i][1] - difference.y().toLy()) * y + (z = this.starCoords[i][2] - difference.z().toLy()) * z);
            if (distance > this.starDistances[i]) {
                return;
            }
            short alpha = this.starRGBA[i][3];
            short minAlpha = (short)(alpha / 10);
            if ((alpha = (short)(alpha - (short)(255.0 * distance / 100000.0))) < minAlpha) {
                alpha = minAlpha;
            }
            double starSize = this.clampStar(hasTexture ? this.starSizes[i] * 4.0 : this.starSizes[i], hasTexture ? (double)0.08f : (double)0.02f, distance);
            distance = 1.0 / distance;
            double starX = (x *= distance) * 100.0;
            double starY = (y *= distance) * 100.0;
            double starZ = (z *= distance) * 100.0;
            double sphericalTheta = Math.atan2(x, z);
            double sinTheta = Math.sin(sphericalTheta);
            double cosTheta = Math.cos(sphericalTheta);
            double xzLength = Math.sqrt(x * x + z * z);
            double sphericalPhi = Math.atan2(xzLength, y);
            double sinPhi = Math.sin(sphericalPhi);
            double cosPhi = Math.cos(sphericalPhi);
            double sinRandom = Math.sin(this.starRotations[i]);
            double cosRandom = Math.cos(this.starRotations[i]);
            for (int j = 0; j < 4; ++j) {
                double aLocation = (j & 2) - 1;
                double bLocation = (j + 1 & 2) - 1;
                double height = (aLocation * cosRandom - bLocation * sinRandom) * starSize;
                double width = (bLocation * cosRandom + aLocation * sinRandom) * starSize;
                double heightProjectionY = height * sinPhi;
                double heightProjectionXZ = -height * cosPhi;
                double projectedX = heightProjectionXZ * sinTheta - width * cosTheta;
                double projectedZ = width * sinTheta + heightProjectionXZ * cosTheta;
                if (hasTexture) {
                    if (VertexOrder.texColor()) {
                        builder.m_5483_(starX + projectedX, starY + heightProjectionY, starZ + projectedZ).m_7421_((float)(aLocation + 1.0) / 2.0f, (float)(bLocation + 1.0) / 2.0f).m_6122_((int)this.starRGBA[i][0], (int)this.starRGBA[i][1], (int)this.starRGBA[i][2], (int)alpha).m_5752_();
                        continue;
                    }
                    builder.m_5483_(starX + projectedX, starY + heightProjectionY, starZ + projectedZ).m_6122_((int)this.starRGBA[i][0], (int)this.starRGBA[i][1], (int)this.starRGBA[i][2], (int)alpha).m_7421_((float)(aLocation + 1.0) / 2.0f, (float)(bLocation + 1.0) / 2.0f).m_5752_();
                    continue;
                }
                builder.m_5483_(starX + projectedX, starY + heightProjectionY, starZ + projectedZ).m_6122_((int)this.starRGBA[i][0], (int)this.starRGBA[i][1], (int)this.starRGBA[i][2], (int)alpha).m_5752_();
            }
        }
    }
}

