/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.api.common.space_objects.resourcepack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;
import net.povstalec.stellarview.api.common.space_objects.OrbitingObject;
import net.povstalec.stellarview.api.common.space_objects.SpaceObject;
import net.povstalec.stellarview.api.common.space_objects.StarLike;
import net.povstalec.stellarview.api.common.space_objects.SupernovaLeftover;
import net.povstalec.stellarview.api.common.space_objects.TexturedObject;
import net.povstalec.stellarview.api.common.space_objects.resourcepack.Nebula;
import net.povstalec.stellarview.common.util.AxisRotation;
import net.povstalec.stellarview.common.util.Color;
import net.povstalec.stellarview.common.util.SpaceCoords;
import net.povstalec.stellarview.common.util.StellarCoordinates;
import net.povstalec.stellarview.common.util.TextureLayer;

public class Star
extends StarLike {
    public static final String SUPERNOVA_INFO = "supernova_info";
    @Nullable
    private SupernovaInfo supernovaInfo;
    public static final Codec<Star> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SpaceObject.ParentInfo.CODEC.optionalFieldOf("parent").forGetter(SpaceObject::getParentInfo), (App)Codec.either(SpaceCoords.CODEC, StellarCoordinates.Equatorial.CODEC).fieldOf("coords").forGetter(object -> Either.left((Object)object.getCoords())), (App)AxisRotation.CODEC.fieldOf("axis_rotation").forGetter(SpaceObject::getAxisRotation), (App)OrbitingObject.OrbitInfo.CODEC.optionalFieldOf("orbit_info").forGetter(star -> Optional.ofNullable(star.orbitInfo())), (App)TextureLayer.CODEC.listOf().fieldOf("texture_layers").forGetter(TexturedObject::getTextureLayers), (App)TexturedObject.FadeOutHandler.CODEC.optionalFieldOf("fade_out_handler", (Object)TexturedObject.FadeOutHandler.DEFAULT_STAR_HANDLER).forGetter(TexturedObject::getFadeOutHandler), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).optionalFieldOf("min_star_size", (Object)Float.valueOf(0.08f)).forGetter(StarLike::getMinStarSize), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("max_star_alpha", (Object)Float.valueOf(1.0f)).forGetter(StarLike::getMaxStarAlpha), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("min_star_alpha", (Object)Float.valueOf(0.1f)).forGetter(StarLike::getMinStarAlpha), (App)SupernovaInfo.CODEC.optionalFieldOf(SUPERNOVA_INFO).forGetter(star -> Optional.ofNullable(star.supernovaInfo()))).apply((Applicative)instance, Star::new));

    public Star() {
    }

    public Star(Optional<SpaceObject.ParentInfo> parent, Either<SpaceCoords, StellarCoordinates.Equatorial> coords, AxisRotation axisRotation, Optional<OrbitingObject.OrbitInfo> orbitInfo, List<TextureLayer> textureLayers, TexturedObject.FadeOutHandler fadeOutHandler, float minStarSize, float maxStarAlpha, float minStarAlpha, Optional<SupernovaInfo> supernovaInfo) {
        super(parent, coords, axisRotation, orbitInfo, textureLayers, fadeOutHandler, minStarSize, maxStarAlpha, minStarAlpha);
        this.supernovaInfo = supernovaInfo.isPresent() ? supernovaInfo.get() : null;
    }

    public boolean isSupernova() {
        return this.supernovaInfo != null;
    }

    @Nullable
    public SupernovaInfo supernovaInfo() {
        return this.supernovaInfo;
    }

    public float supernovaSize(float size, long ticks, double lyDistance) {
        if (this.supernovaInfo.supernovaEnded(ticks)) {
            return 0.0f;
        }
        if (!this.supernovaInfo.supernovaStarted(ticks)) {
            return size;
        }
        long lifetime = this.supernovaInfo.lifetime(ticks);
        float sizeMultiplier = this.supernovaInfo.getMaxSizeMultiplier() * (float)Math.sin(Math.PI * (double)lifetime / (double)this.supernovaInfo.getDurationTicks());
        return sizeMultiplier > 1.0f || (float)lifetime > (float)(this.supernovaInfo.getDurationTicks() / 2L) ? sizeMultiplier * size : size;
    }

    public float rotation(long ticks) {
        if (!this.isSupernova() || !this.supernovaInfo.supernovaStarted(ticks)) {
            return 0.0f;
        }
        return (float)(Math.PI * (double)this.supernovaInfo.lifetime(ticks) / (double)this.supernovaInfo.getDurationTicks());
    }

    public Color.FloatRGBA supernovaRGBA(long ticks, double lyDistance) {
        Color.FloatRGBA starRGBA = super.starRGBA(lyDistance);
        if (!this.isSupernova() || this.supernovaInfo.supernovaEnded(ticks) || !this.supernovaInfo.supernovaStarted(ticks)) {
            return starRGBA;
        }
        float alphaDif = 1.0f - starRGBA.alpha();
        float alpha = starRGBA.alpha() + alphaDif * (float)Math.sin(Math.PI * (double)this.supernovaInfo.lifetime(ticks) / (double)this.supernovaInfo.getDurationTicks());
        starRGBA.setAlpha(alpha <= 0.0f ? 0.0f : (alpha >= 1.0f ? 1.0f : alpha));
        return starRGBA;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        if (this.supernovaInfo != null) {
            tag.m_128365_(SUPERNOVA_INFO, (Tag)this.supernovaInfo.serializeNBT());
        }
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        if (tag.m_128441_("orbit_info")) {
            this.supernovaInfo = new SupernovaInfo();
            this.supernovaInfo.deserializeNBT(tag.m_128469_(SUPERNOVA_INFO));
        } else {
            this.supernovaInfo = null;
        }
    }

    public static class SupernovaInfo
    implements INBTSerializable<CompoundTag> {
        public static final String MAX_SIZE_MULTIPLIER = "max_size_multiplier";
        public static final String START_TICKS = "start_ticks";
        public static final String DURATION_TICKS = "duration_ticks";
        public static final String NEBULA = "nebula";
        public static final String SUPERNOVA_LEFTOVER = "supernova_leftover";
        protected Nebula nebula;
        protected SupernovaLeftover supernovaLeftover;
        protected float maxSizeMultiplier;
        protected long startTicks;
        protected long durationTicks;
        protected long endTicks;
        public static final Codec<SupernovaInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf(MAX_SIZE_MULTIPLIER).forGetter(SupernovaInfo::getMaxSizeMultiplier), (App)Codec.LONG.fieldOf(START_TICKS).forGetter(SupernovaInfo::getStartTicks), (App)Codec.LONG.fieldOf(DURATION_TICKS).forGetter(SupernovaInfo::getDurationTicks), (App)Nebula.CODEC.fieldOf(NEBULA).forGetter(SupernovaInfo::getNebula), (App)SupernovaLeftover.CODEC.fieldOf(SUPERNOVA_LEFTOVER).forGetter(SupernovaInfo::getSupernovaLeftover)).apply((Applicative)instance, SupernovaInfo::new));

        public SupernovaInfo() {
        }

        public SupernovaInfo(float maxSizeMultiplier, long startTicks, long durationTicks, Nebula nebula, SupernovaLeftover supernovaLeftover) {
            this.maxSizeMultiplier = maxSizeMultiplier;
            this.startTicks = startTicks;
            this.durationTicks = durationTicks;
            this.endTicks = startTicks + durationTicks;
            this.nebula = nebula;
            this.supernovaLeftover = supernovaLeftover;
        }

        public Nebula getNebula() {
            return this.nebula;
        }

        public SupernovaLeftover getSupernovaLeftover() {
            return this.supernovaLeftover;
        }

        public float getMaxSizeMultiplier() {
            return this.maxSizeMultiplier;
        }

        public long getStartTicks() {
            return this.startTicks;
        }

        public long getDurationTicks() {
            return this.durationTicks;
        }

        public long getEndTicks() {
            return this.endTicks;
        }

        public boolean supernovaStarted(long ticks) {
            return ticks > this.getStartTicks();
        }

        public boolean supernovaEnded(long ticks) {
            return ticks > this.getEndTicks();
        }

        public long lifetime(long ticks) {
            return ticks - this.getStartTicks();
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128350_(MAX_SIZE_MULTIPLIER, this.maxSizeMultiplier);
            tag.m_128356_(START_TICKS, this.startTicks);
            tag.m_128356_(DURATION_TICKS, this.durationTicks);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            this.maxSizeMultiplier = tag.m_128457_(MAX_SIZE_MULTIPLIER);
            this.startTicks = tag.m_128454_(START_TICKS);
            this.durationTicks = tag.m_128454_(DURATION_TICKS);
        }
    }
}

