/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.common.network;

import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.platform.network.ChannelHandler;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.sleep_tight.STPlatStuff;
import net.mehvahdjukaar.sleep_tight.SleepTightClient;
import net.mehvahdjukaar.sleep_tight.core.PlayerSleepData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class ClientBoundSyncPlayerSleepCapMessage
implements Message {
    @Nullable
    private final UUID lastBedSleptInto;
    private final long insomniaWillElapseTimestamp;
    private final long lastWokenUpTimestamp;
    private final int consecutiveNights;
    private final int homeBedNights;
    private final boolean doubleBed;

    public ClientBoundSyncPlayerSleepCapMessage(FriendlyByteBuf buf) {
        this.lastBedSleptInto = buf.readBoolean() ? buf.m_130259_() : null;
        this.insomniaWillElapseTimestamp = buf.readLong();
        this.lastWokenUpTimestamp = buf.readLong();
        this.consecutiveNights = buf.readInt();
        this.homeBedNights = buf.readInt();
        this.doubleBed = buf.readBoolean();
    }

    public ClientBoundSyncPlayerSleepCapMessage(PlayerSleepData c) {
        this.lastBedSleptInto = c.getLastBedSleptInto();
        this.insomniaWillElapseTimestamp = c.getInsomniaWillElapseTime();
        this.lastWokenUpTimestamp = c.getLastWokenUpTime();
        this.consecutiveNights = c.getConsecutiveNightsSlept();
        this.homeBedNights = c.getNightsSleptInHomeBed();
        this.doubleBed = c.usingDoubleBed();
    }

    public ClientBoundSyncPlayerSleepCapMessage(Player player) {
        this(STPlatStuff.getPlayerSleepData(player));
    }

    public void writeToBuffer(FriendlyByteBuf buf) {
        buf.writeBoolean(this.lastBedSleptInto != null);
        if (this.lastBedSleptInto != null) {
            buf.m_130077_(this.lastBedSleptInto);
        }
        buf.writeLong(this.insomniaWillElapseTimestamp);
        buf.writeLong(this.lastWokenUpTimestamp);
        buf.writeInt(this.consecutiveNights);
        buf.writeInt(this.homeBedNights);
        buf.writeBoolean(this.doubleBed);
    }

    public void handle(ChannelHandler.Context context) {
        Player p = SleepTightClient.getPlayer();
        if (p == null) {
            return;
        }
        PlayerSleepData data = STPlatStuff.getPlayerSleepData(p);
        data.acceptFromServer(this.lastBedSleptInto, this.insomniaWillElapseTimestamp, this.lastWokenUpTimestamp, this.consecutiveNights, this.homeBedNights, this.doubleBed);
    }
}

