/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.common.entities;

import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.entity.IControllableVehicle;
import net.mehvahdjukaar.moonlight.api.entity.IExtraClientSpawnData;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.sleep_tight.STPlatStuff;
import net.mehvahdjukaar.sleep_tight.SleepTight;
import net.mehvahdjukaar.sleep_tight.SleepTightClient;
import net.mehvahdjukaar.sleep_tight.client.ClientEvents;
import net.mehvahdjukaar.sleep_tight.common.HammockPart;
import net.mehvahdjukaar.sleep_tight.common.blocks.HammockBlock;
import net.mehvahdjukaar.sleep_tight.common.blocks.IModBed;
import net.mehvahdjukaar.sleep_tight.common.network.ClientBoundAlightCameraOnLayMessage;
import net.mehvahdjukaar.sleep_tight.common.network.ClientBoundSleepImmediatelyMessage;
import net.mehvahdjukaar.sleep_tight.common.network.NetworkHandler;
import net.mehvahdjukaar.sleep_tight.common.network.ServerBoundCommitSleepMessage;
import net.mehvahdjukaar.sleep_tight.common.tiles.HammockTile;
import net.mehvahdjukaar.sleep_tight.configs.CommonConfigs;
import net.mehvahdjukaar.sleep_tight.core.PlayerSleepData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class BedEntity
extends Entity
implements IControllableVehicle,
IExtraClientSpawnData {
    private Direction dir = Direction.NORTH;
    public static final EntityDataSerializer<OffsetMode> SERIALIZER = EntityDataSerializer.m_238090_(OffsetMode.class);
    private static final EntityDataAccessor<OffsetMode> DATA_OFFSET = SynchedEntityData.m_135353_(BedEntity.class, SERIALIZER);
    private BlockState lastBedState = Blocks.f_50016_.m_49966_();
    private boolean dismountOnTheSpot = false;

    public BedEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public BedEntity(Level worldIn, BlockPos mainPos, BlockState bedState, OffsetMode offsetMode) {
        super(SleepTight.BED_ENTITY.get(), worldIn);
        Direction bedDir = (Direction)bedState.m_61143_((Property)BedBlock.f_54117_);
        this.dir = bedDir.m_122424_();
        this.m_146922_(this.dir.m_122435_());
        this.lastBedState = bedState;
        this.setOffsetMode(offsetMode);
        VoxelShape shape = bedState.m_60808_((BlockGetter)worldIn, mainPos);
        double yOffset = shape.m_83297_(Direction.Axis.Y);
        this.m_6034_((double)mainPos.m_123341_() + 0.5, (double)mainPos.m_123342_() + yOffset, (double)mainPos.m_123343_() + 0.5);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_OFFSET, (Object)OffsetMode.NONE);
    }

    public OffsetMode getOffsetMode() {
        return (OffsetMode)((Object)this.f_19804_.m_135370_(DATA_OFFSET));
    }

    public void setOffsetMode(OffsetMode mode) {
        this.f_19804_.m_135381_(DATA_OFFSET, (Object)mode);
    }

    public Direction getBedDirection() {
        return this.dir;
    }

    public boolean isDoubleBed() {
        return this.getOffsetMode() == OffsetMode.DOUBLE_BED;
    }

    public void clearDoubleBed() {
        if (this.getOffsetMode() == OffsetMode.DOUBLE_BED) {
            this.setOffsetMode(OffsetMode.NONE);
            BlockPos otherPos = this.getDoubleBedPos();
            Level level = this.m_9236_();
            BlockState otherState = level.m_8055_(otherPos);
            if (otherState == this.lastBedState) {
                level.m_46597_(otherPos, (BlockState)otherState.m_61124_((Property)BedBlock.f_49441_, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    public void m_8119_() {
        BlockPos otherPos;
        super.m_8119_();
        Level level = this.m_9236_();
        List passengers = this.m_20197_();
        for (Entity p : passengers) {
            p.m_20124_(Pose.SLEEPING);
            if (this.f_19797_ <= 2 || level.f_46443_ || !CommonConfigs.SLEEP_IMMEDIATELY.get().booleanValue() || !(p instanceof ServerPlayer)) continue;
            ServerPlayer sp = (ServerPlayer)p;
            this.startSleepingOn(sp);
        }
        boolean dead = passengers.isEmpty();
        BlockPos pos = this.m_20183_();
        BlockState newBedState = level.m_8055_(pos);
        boolean isBed = this.isValidBed(newBedState);
        if (this.isDoubleBed() && this.f_19797_ > 2 && level.m_8055_(otherPos = this.getDoubleBedPos()) != newBedState) {
            this.clearDoubleBed();
        }
        if (isBed) {
            this.dir = ((Direction)newBedState.m_61143_((Property)BedBlock.f_54117_)).m_122424_();
        }
        if (!dead && !isBed) {
            PistonMovingBlockEntity pistonBE;
            PistonMovingBlockEntity piston = null;
            boolean didOffsetByPiston = false;
            BlockEntity tile = level.m_7702_(pos);
            if (tile instanceof PistonMovingBlockEntity && this.isValidBed((pistonBE = (PistonMovingBlockEntity)tile).m_60400_())) {
                piston = pistonBE;
            } else {
                for (Direction d : Direction.values()) {
                    PistonMovingBlockEntity pistonBE2;
                    BlockPos offPos = pos.m_121945_(d);
                    tile = level.m_7702_(offPos);
                    if (!(tile instanceof PistonMovingBlockEntity) || !this.isValidBed((pistonBE2 = (PistonMovingBlockEntity)tile).m_60400_())) continue;
                    piston = pistonBE2;
                    break;
                }
            }
            if (piston != null) {
                Direction dir = piston.m_60399_();
                this.m_6478_(MoverType.PISTON, new Vec3((double)dir.m_122429_() * 0.33, (double)dir.m_122430_() * 0.33, (double)dir.m_122431_() * 0.33));
                didOffsetByPiston = true;
                this.clearDoubleBed();
            }
            boolean bl = dead = !didOffsetByPiston;
        }
        if (dead && !level.f_46443_) {
            if (isBed) {
                level.m_46597_(pos, (BlockState)newBedState.m_61124_((Property)BedBlock.f_49441_, (Comparable)Boolean.valueOf(false)));
            }
            this.clearDoubleBed();
            this.m_146870_();
        }
        this.lastBedState = newBedState;
    }

    public static Vec3 getDoubleBedOffset(Direction dir, Vec3 vec3) {
        Direction d = dir.m_122428_();
        return vec3.m_82520_((double)d.m_122429_() * -0.5, 0.0, (double)d.m_122431_() * -0.5);
    }

    public static BlockPos getDoubleBedPos(BlockPos pos, BlockState state) {
        return pos.m_121945_(((Direction)state.m_61143_((Property)BedBlock.f_54117_)).m_122427_());
    }

    public static BlockPos getInverseDoubleBedPos(BlockPos pos, BlockState state) {
        return pos.m_121945_(((Direction)state.m_61143_((Property)BedBlock.f_54117_)).m_122428_());
    }

    public BlockPos getDoubleBedPos() {
        return this.m_20183_().m_121945_(this.dir.m_122428_());
    }

    private boolean isValidBed(BlockState state) {
        Block b = state.m_60734_();
        if (b instanceof BedBlock) {
            return state.m_61143_((Property)BedBlock.f_49440_) == BedPart.HEAD;
        }
        if (b instanceof HammockBlock) {
            return ((HammockPart)((Object)state.m_61143_(HammockBlock.PART))).isMaster();
        }
        return false;
    }

    public boolean m_6000_(double x, double y, double z) {
        return false;
    }

    public boolean m_6783_(double distance) {
        return false;
    }

    protected void m_7378_(@NotNull CompoundTag compound) {
        this.setOffsetMode(OffsetMode.values()[compound.m_128445_("mode")]);
    }

    protected void m_7380_(@NotNull CompoundTag compound) {
        compound.m_128344_("mode", (byte)this.getOffsetMode().ordinal());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return PlatHelper.getEntitySpawnPacket((Entity)this);
    }

    public double m_6048_() {
        return 0.0125;
    }

    protected void m_19956_(Entity passenger, Entity.MoveFunction callback) {
        if (this.m_20363_(passenger)) {
            Block block = this.lastBedState.m_60734_();
            if (block instanceof IModBed) {
                IModBed b = (IModBed)block;
                Vec3 v = b.getSleepingPosition(this.lastBedState, this.m_20183_());
                callback.m_20372_(passenger, v.f_82479_, v.f_82480_, v.f_82481_);
            } else {
                Vec3 c = this.m_20182_();
                if (this.isDoubleBed()) {
                    c = BedEntity.getDoubleBedOffset(this.dir.m_122424_(), c);
                }
                callback.m_20372_(passenger, c.f_82479_, c.f_82480_, c.f_82481_);
            }
        }
    }

    public void m_7340_(Entity entity) {
        float diff = Mth.m_14177_((float)(entity.m_6080_() - this.m_146908_()));
        float clampedDiff = Mth.m_14036_((float)diff, (float)-90.0f, (float)90.0f);
        float subtract = clampedDiff - diff;
        ((LivingEntity)entity).f_20885_ += subtract;
        entity.m_146926_(Mth.m_14036_((float)entity.m_146909_(), (float)-75.0f, (float)0.0f));
    }

    protected void m_20348_(Entity passenger) {
        Player player;
        super.m_20348_(passenger);
        this.m_7332_(passenger);
        passenger.m_146922_(this.m_146908_());
        passenger.m_146867_();
        passenger.m_20124_(Pose.SLEEPING);
        if (passenger instanceof Player && (player = (Player)passenger).m_7578_()) {
            ClientEvents.displayRidingMessage(this);
            BedEntity.alignCamera(player, this.m_146908_());
        }
    }

    public static void alignCamera(Player player, float bedYRot) {
        player.m_146922_(bedYRot);
        player.m_5616_(bedYRot);
        player.f_19859_ = player.m_146908_();
        player.f_20886_ = player.f_20885_;
    }

    protected void m_20351_(Entity passenger) {
        Player p;
        super.m_20351_(passenger);
        this.m_7332_(passenger);
        if (passenger instanceof Player && (p = (Player)passenger).m_5803_()) {
            passenger.m_20124_(Pose.SLEEPING);
        } else {
            passenger.m_20124_(Pose.STANDING);
        }
    }

    public void onInputUpdate(boolean left, boolean right, boolean up, boolean down, boolean sprint, boolean jumping) {
        BlockEntity blockEntity;
        if (jumping) {
            NetworkHandler.CHANNEL.sendToServer((Message)new ServerBoundCommitSleepMessage());
            if (this.m_9236_().f_46443_ && SleepTightClient.HAS_SNORE) {
                ((Entity)this.m_20197_().get(0)).m_5496_(SleepTight.SNORE_SOUND.get(), 1.0f, Mth.m_216283_((RandomSource)this.f_19796_, (float)0.9f, (float)1.1f));
            }
        } else if (left ^ right && (blockEntity = this.m_9236_().m_7702_(this.m_20097_())) instanceof HammockTile) {
            HammockTile tile = (HammockTile)blockEntity;
            if (left) {
                tile.accelerateLeft();
            } else {
                tile.accelerateRight();
            }
        }
    }

    public void writeSpawnData(FriendlyByteBuf buf) {
        buf.writeInt(this.dir.m_122416_());
        buf.writeInt(this.getOffsetMode().ordinal());
        boolean isValid = !this.m_20197_().isEmpty();
        buf.writeBoolean(isValid);
        if (isValid) {
            buf.m_130077_(((Entity)this.m_20197_().get(0)).m_20148_());
        }
    }

    public void readSpawnData(FriendlyByteBuf buf) {
        this.dir = Direction.m_122407_((int)buf.readInt());
        this.setOffsetMode(OffsetMode.values()[buf.readInt()]);
        if (buf.readBoolean()) {
            UUID uniqueId = buf.m_130259_();
            Player p = this.m_9236_().m_46003_(uniqueId);
            if (p != null) {
                p.m_20329_((Entity)this);
            }
        }
    }

    public MutableComponent getRidingMessage(Component keyMessage, Component shiftMessage) {
        this.lastBedState = this.m_9236_().m_8055_(this.m_20183_());
        if (this.lastBedState.m_60734_() instanceof HammockBlock) {
            return Component.m_237110_((String)"message.sleep_tight.start_resting", (Object[])new Object[]{keyMessage, shiftMessage});
        }
        return Component.m_237110_((String)"message.sleep_tight.start_sleeping", (Object[])new Object[]{keyMessage, shiftMessage});
    }

    public boolean m_6097_() {
        return false;
    }

    public boolean m_7313_(Entity entity) {
        return true;
    }

    public boolean m_20147_() {
        return true;
    }

    public Vec3 m_7688_(LivingEntity passenger) {
        if (this.dismountOnTheSpot) {
            return super.m_7688_(passenger);
        }
        Optional o = BedBlock.m_260958_((EntityType)passenger.m_6095_(), (CollisionGetter)passenger.m_9236_(), (BlockPos)this.m_20183_(), (Direction)this.dir.m_122424_(), (float)passenger.m_146908_());
        return o.orElseGet(() -> super.m_7688_(passenger));
    }

    private static boolean isHammock3L(BlockState state) {
        return state.m_60734_() instanceof HammockBlock && !((HammockPart)((Object)state.m_61143_(HammockBlock.PART))).isOnFence();
    }

    public void startSleepingOn(ServerPlayer player) {
        BlockPos pos = this.m_20183_();
        if (!this.isValidBed(this.m_9236_().m_8055_(pos))) {
            return;
        }
        this.dismountOnTheSpot = true;
        Either r = player.m_7720_(pos);
        this.dismountOnTheSpot = false;
        Optional op = r.left();
        if (op.isPresent()) {
            Component m;
            Block block;
            player.m_7998_((Entity)this, true);
            Player.BedSleepingProblem problem = (Player.BedSleepingProblem)op.get();
            if (problem == Player.BedSleepingProblem.NOT_POSSIBLE_NOW && (block = this.lastBedState.m_60734_()) instanceof IModBed) {
                IModBed mb = (IModBed)block;
                m = mb.getSleepingProblemMessage();
            } else {
                m = problem.m_36423_();
            }
            if (m != null) {
                player.m_5661_(m, true);
            }
        } else {
            player.m_6038_();
            PlayerSleepData data = STPlatStuff.getPlayerSleepData((Player)player);
            data.setDoubleBed(this.isDoubleBed());
            data.syncToClient(player);
            NetworkHandler.CHANNEL.sendToClientPlayer(player, (Message)new ClientBoundSleepImmediatelyMessage(pos));
            Level level = this.m_9236_();
            BlockState blockState = level.m_8055_(pos);
            if (blockState.m_60734_() instanceof BedBlock) {
                level.m_46597_(pos, (BlockState)blockState.m_61124_((Property)BedBlock.f_49441_, (Comparable)Boolean.valueOf(true)));
            }
            this.m_146870_();
        }
    }

    public static void layDown(BlockState state, BlockPos pos, Player player) {
        Level level = player.m_9236_();
        if (!level.f_46443_) {
            OffsetMode mode = OffsetMode.NONE;
            if (BedEntity.isHammock3L(state)) {
                mode = OffsetMode.HAMMOCK_3L;
            }
            if (CommonConfigs.DOUBLE_BED.get().booleanValue() && state.m_204336_(BlockTags.f_13038_)) {
                Direction dir = ((Direction)state.m_61143_((Property)BedBlock.f_54117_)).m_122427_();
                BlockPos relative = pos.m_121945_(dir);
                BlockState s = level.m_8055_(relative);
                if (s == state) {
                    level.m_46597_(relative, (BlockState)state.m_61124_((Property)BedBlock.f_49441_, (Comparable)Boolean.valueOf(true)));
                    mode = OffsetMode.DOUBLE_BED;
                } else {
                    relative = pos.m_121945_(dir = dir.m_122424_());
                    s = level.m_8055_(relative);
                    if (s == state) {
                        level.m_46597_(pos, (BlockState)state.m_61124_((Property)BedBlock.f_49441_, (Comparable)Boolean.valueOf(true)));
                        mode = OffsetMode.DOUBLE_BED;
                        pos = relative;
                    }
                }
            }
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)BedBlock.f_49441_, (Comparable)Boolean.valueOf(true)));
            BedEntity bedEntity = new BedEntity(level, pos, state, mode);
            player.m_20329_((Entity)bedEntity);
            level.m_7967_((Entity)bedEntity);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                NetworkHandler.CHANNEL.sendToClientPlayer(serverPlayer, (Message)new ClientBoundAlightCameraOnLayMessage(bedEntity));
            }
        } else {
            BlockEntity mode = level.m_7702_(pos);
            if (mode instanceof HammockTile) {
                HammockTile tile = (HammockTile)mode;
                Vec3 d = player.m_20184_();
                double vel = d.m_82526_(MthUtils.V3itoV3((Vec3i)tile.getDirection().m_122427_().m_122436_())) / d.m_82553_();
                tile.addImpulse((float)(-vel * (double)1.1f));
            }
        }
    }

    public static enum OffsetMode {
        NONE,
        HAMMOCK_3L,
        DOUBLE_BED;

    }
}

