/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.client.particles;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.moonlight.core.client.MLRenderTypes;
import net.mehvahdjukaar.sleep_tight.configs.ClientConfigs;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class DreamParticle
extends TextureSheetParticle {
    private static final int FADE_START = 40;
    private float maxAlpha;
    private final float deltaRot;
    private final ParticleRenderType renderType;

    protected DreamParticle(ClientLevel clientLevel, double x, double y, double z, double vx, double vy, double vz) {
        super(clientLevel, x, y, z, vx, vy, vz);
        float g = 0.4f + this.f_107223_.m_188501_() * 0.25f;
        this.f_107227_ = Math.max(0.0f, Mth.m_14031_((float)((g + 0.0f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
        this.f_107228_ = Math.max(0.0f, Mth.m_14031_((float)((g + 0.33333334f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
        this.f_107229_ = Math.max(0.0f, Mth.m_14031_((float)((g + 0.6666667f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
        int l = ClientConfigs.PARTICLE_LIFETIME.get();
        this.f_107225_ = l + (int)MthUtils.nextWeighted((RandomSource)this.f_107223_, (float)((float)l * 0.6f), (float)1.0f);
        this.f_107230_ = 0.01f;
        this.deltaRot = (0.002f + MthUtils.nextWeighted((RandomSource)this.f_107223_, (float)0.05f, (float)10.0f)) * (float)(this.f_107223_.m_188499_() ? -1 : 1);
        this.f_107663_ = 0.04f + MthUtils.nextWeighted((RandomSource)this.f_107223_, (float)0.08f, (float)200.0f);
        this.f_107231_ = (float)(Math.PI * (double)this.f_107223_.m_188501_());
        this.f_172258_ = 0.995f;
        this.f_107226_ = 0.0f;
        this.f_107215_ *= 0.005;
        this.f_107215_ += vx;
        this.f_107217_ *= 0.005;
        this.f_107217_ += vz;
        this.f_107216_ = vy;
        this.m_107250_(0.1f, 0.1f);
        this.maxAlpha = (float)ClientConfigs.PARTICLE_ALPHA.get().doubleValue();
        this.renderType = MLRenderTypes.PARTICLE_ADDITIVE_TRANSLUCENCY_RENDER_TYPE;
    }

    public ParticleRenderType m_7556_() {
        return this.renderType;
    }

    public void m_5989_() {
        super.m_5989_();
        this.f_107204_ = this.f_107231_;
        this.f_107231_ += this.deltaRot;
        int timeLeft = this.f_107225_ - this.f_107224_;
        if (this.f_107224_ < 40) {
            this.f_107230_ += this.maxAlpha / 40.0f;
            this.f_107230_ = Math.min(this.f_107230_, this.maxAlpha);
        } else if (timeLeft < 40) {
            this.f_107230_ = this.maxAlpha * (float)timeLeft / 40.0f;
        }
    }

    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        Quaternionf quaternion;
        Vec3 pos = renderInfo.m_90583_();
        float x = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - pos.m_7096_());
        float y = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - pos.m_7098_());
        float z = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - pos.m_7094_());
        if (this.f_107231_ == 0.0f) {
            quaternion = renderInfo.m_253121_();
        } else {
            quaternion = new Quaternionf((Quaternionfc)renderInfo.m_253121_());
            float i = Mth.m_14179_((float)partialTicks, (float)this.f_107204_, (float)this.f_107231_);
            quaternion.mul((Quaternionfc)Axis.f_252403_.m_252961_(i));
        }
        Vector3f[] vector3fs = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float size = this.m_5902_(partialTicks);
        for (int k = 0; k < 4; ++k) {
            Vector3f vector3f2 = vector3fs[k];
            vector3f2.rotate((Quaternionfc)quaternion);
            vector3f2.mul(size);
            vector3f2.add(x, y, z);
        }
        float u0 = this.m_5970_();
        float u1 = this.m_5952_();
        float v0 = this.m_5951_();
        float v1 = this.m_5950_();
        int light = this.m_6355_(partialTicks);
        buffer.m_5483_((double)vector3fs[0].x(), (double)vector3fs[0].y(), (double)vector3fs[0].z()).m_7421_(u1, v1).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        buffer.m_5483_((double)vector3fs[1].x(), (double)vector3fs[1].y(), (double)vector3fs[1].z()).m_7421_(u1, v0).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        buffer.m_5483_((double)vector3fs[2].x(), (double)vector3fs[2].y(), (double)vector3fs[2].z()).m_7421_(u0, v0).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        buffer.m_5483_((double)vector3fs[3].x(), (double)vector3fs[3].y(), (double)vector3fs[3].z()).m_7421_(u0, v1).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
    }

    protected int m_6355_(float partialTick) {
        BlockPos pos = BlockPos.m_274561_((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_);
        if (!this.f_107208_.m_46805_(pos)) {
            return 0;
        }
        int i = this.f_107208_.m_45517_(LightLayer.SKY, pos);
        int j = this.f_107208_.m_45517_(LightLayer.BLOCK, pos);
        if (j < 10) {
            j = 10;
        }
        return i << 20 | j << 4;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Factory(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType pType, ClientLevel level, double pX, double pY, double pZ, double period, double unused, double mode) {
            DreamParticle p;
            if (mode == 1.0) {
                float h = (float)period;
                float ampl = 0.001f;
                float dx = ampl * Mth.m_14031_((float)((float)Math.PI * 2 * h));
                float dz = ampl * Mth.m_14089_((float)((float)Math.PI * 2 * h));
                float vy = 0.003f + MthUtils.nextWeighted((RandomSource)level.f_46441_, (float)0.004f, (float)10.0f);
                p = new DreamParticle(level, pX, pY, pZ, dx, vy, dz);
            } else if (mode == 2.0) {
                float yaw = level.f_46441_.m_188501_() * 2.0f * (float)Math.PI;
                float pitch = Mth.m_216283_((RandomSource)level.f_46441_, (float)-0.1f, (float)0.5f) * (float)Math.PI;
                float len = 0.4f + level.f_46441_.m_188501_() * 0.3f;
                Vec3 v = new Vec3(0.0, 0.0, (double)len).m_82496_(pitch).m_82524_(yaw);
                p = new DreamParticle(level, pX + v.f_82479_ * 0.5, pY + v.f_82480_ * 0.5, pZ + v.f_82481_ * 0.5, v.f_82479_, v.f_82480_ * 0.75, v.f_82481_);
                p.f_172258_ = 0.78f;
                p.maxAlpha *= 2.0f;
                p.f_107230_ = p.maxAlpha;
                p.m_107257_(60 + level.f_46441_.m_188503_(180));
            } else {
                p = new DreamParticle(level, pX, pY, pZ, period, unused, mode);
            }
            p.m_108339_(this.sprite);
            return p;
        }
    }
}

