/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.state;

import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;

public enum VerticalSlabState implements StringRepresentable
{
    NORTH(0, "north", Direction.NORTH),
    WEST(1, "west", Direction.WEST),
    EAST(2, "east", Direction.EAST),
    SOUTH(3, "south", Direction.SOUTH),
    DOUBLEX(4, "double_x", Direction.EAST),
    DOUBLEZ(5, "double_z", Direction.NORTH);

    private static final VerticalSlabState[] META_LOOKUP;
    private final int meta;
    private final String name;
    private final Direction facing;

    private VerticalSlabState(int meta, String name, Direction facing) {
        this.meta = meta;
        this.name = name;
        this.facing = facing;
    }

    public int getMetadata() {
        return this.meta;
    }

    public Direction getFacing() {
        return this.facing;
    }

    public String toString() {
        return this.name;
    }

    public static VerticalSlabState byMetadata(int meta) {
        if (meta < 0 || meta >= META_LOOKUP.length) {
            meta = 0;
        }
        return META_LOOKUP[meta];
    }

    public boolean isDouble() {
        return this == DOUBLEX || this == DOUBLEZ;
    }

    public static VerticalSlabState forFacings(Direction clickedSide, Direction entityFacing) {
        if (clickedSide == Direction.UP || clickedSide == Direction.DOWN) {
            if (entityFacing == Direction.NORTH) {
                return NORTH;
            }
            if (entityFacing == Direction.EAST) {
                return EAST;
            }
            if (entityFacing == Direction.SOUTH) {
                return SOUTH;
            }
            if (entityFacing == Direction.WEST) {
                return WEST;
            }
        }
        if (clickedSide == Direction.NORTH) {
            return SOUTH;
        }
        if (clickedSide == Direction.EAST) {
            return WEST;
        }
        if (clickedSide == Direction.SOUTH) {
            return NORTH;
        }
        if (clickedSide == Direction.WEST) {
            return EAST;
        }
        return NORTH;
    }

    public String m_7912_() {
        return this.name;
    }

    public static VerticalSlabState reverseFacing(Direction facing, boolean doub) {
        if (doub) {
            return facing.m_122434_() == Direction.Axis.X ? DOUBLEX : DOUBLEZ;
        }
        switch (facing) {
            case EAST: {
                return EAST;
            }
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case WEST: {
                return WEST;
            }
        }
        return NORTH;
    }

    static {
        META_LOOKUP = new VerticalSlabState[VerticalSlabState.values().length];
        VerticalSlabState[] verticalSlabStateArray = VerticalSlabState.values();
        int n = verticalSlabStateArray.length;
        for (int i = 0; i < n; ++i) {
            VerticalSlabState d;
            VerticalSlabState.META_LOOKUP[d.getMetadata()] = d = verticalSlabStateArray[i];
        }
    }
}

