/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.blocks;

import com.mrh0.buildersaddition.blocks.base.BaseDerivativeBlock;
import com.mrh0.buildersaddition.blocks.base.IConnects;
import com.mrh0.buildersaddition.config.Config;
import com.mrh0.buildersaddition.state.PillarState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Pillar
extends BaseDerivativeBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<PillarState> STATE = EnumProperty.m_61587_((String)"state", PillarState.class);
    protected static final AABB PILLAR = new AABB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);
    protected static final AABB PILLAR_NOT_CONNECTED = new AABB(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375);
    protected static final AABB PILLAR_BOTTOM = new AABB(0.0625, 0.0, 0.0625, 0.9375, 0.125, 0.9375);
    protected static final AABB PILLAR_TOP = new AABB(0.0625, 0.875, 0.0625, 0.9375, 1.0, 0.9375);
    private final int light;
    private final IConnects iconnect;

    public Pillar(String name, Block source, int light, IConnects connects) {
        super("cut_" + name + "_pillar", source);
        this.light = light;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(STATE, (Comparable)((Object)PillarState.Both))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.iconnect = connects;
    }

    public Pillar(String name, Block source, IConnects connects) {
        this(name, source, 0, connects);
    }

    public Pillar(String name, Block source, int light) {
        this(name, source, (BlockState state, Block b) -> state.m_60734_() == b);
    }

    public Pillar(String name, Block source) {
        this(name, source, 0);
    }

    public int m_7753_(BlockState state, BlockGetter wolrd, BlockPos pos) {
        return state.m_61143_(STATE) == PillarState.Top ? this.light : 0;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{STATE, WATERLOGGED});
    }

    public VoxelShape getShape(BlockState state) {
        switch ((PillarState)((Object)state.m_61143_(STATE))) {
            case None: {
                return Shapes.m_83064_((AABB)PILLAR);
            }
            case Top: {
                return Shapes.m_83110_((VoxelShape)Shapes.m_83064_((AABB)PILLAR), (VoxelShape)Shapes.m_83064_((AABB)PILLAR_TOP));
            }
            case Bottom: {
                return Shapes.m_83110_((VoxelShape)Shapes.m_83064_((AABB)PILLAR), (VoxelShape)Shapes.m_83064_((AABB)PILLAR_BOTTOM));
            }
            case Both: {
                return Shapes.m_83064_((AABB)PILLAR_NOT_CONNECTED);
            }
        }
        return Shapes.m_83064_((AABB)PILLAR);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.getShape(state);
    }

    public BlockState getState(BlockState state, BlockGetter worldIn, BlockPos pos) {
        boolean bottom;
        BlockState bstop = worldIn.m_8055_(pos.m_7494_());
        BlockState bsbottom = worldIn.m_8055_(pos.m_7495_());
        boolean top = !this.connects(bstop, this);
        boolean bl = bottom = !this.connects(bsbottom, this);
        if (top && bottom) {
            return (BlockState)state.m_61124_(STATE, (Comparable)((Object)PillarState.Both));
        }
        if (top) {
            return (BlockState)state.m_61124_(STATE, (Comparable)((Object)PillarState.Top));
        }
        if (bottom) {
            return (BlockState)state.m_61124_(STATE, (Comparable)((Object)PillarState.Bottom));
        }
        return (BlockState)state.m_61124_(STATE, (Comparable)((Object)PillarState.None));
    }

    public BlockState m_5573_(BlockPlaceContext c) {
        return (BlockState)this.getState(this.m_49966_(), (BlockGetter)c.m_43725_(), c.m_8083_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(c.m_43725_().m_6425_(c.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    public boolean connects(BlockState state, Block block) {
        return this.iconnect.connect(state, block) || this.connectsAll(state, block);
    }

    private boolean connectsAll(BlockState state, Block block) {
        return state.m_60734_() instanceof Pillar && (Boolean)Config.PILLARS_CONNECT_ALL.get() != false;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7361_(LevelAccessor world, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        return super.m_7361_(world, pos, state, fluidStateIn);
    }

    public boolean m_6044_(BlockGetter world, BlockPos pos, BlockState state, Fluid fluidIn) {
        return super.m_6044_(world, pos, state, fluidIn);
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        switch (type) {
            case LAND: {
                return false;
            }
            case WATER: {
                return world.m_6425_(pos).m_205070_(FluidTags.f_13131_);
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState otherState, LevelAccessor world, BlockPos currentPos, BlockPos otherPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return this.getState(state, (BlockGetter)world, currentPos);
    }
}

