/*
 * Decompiled with CFR 0.152.
 */
package zed.d0c.floormats;

import java.util.Objects;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import zed.d0c.floormats.Config;
import zed.d0c.floormats.clusters.Clusters;
import zed.d0c.floormats.compat.top.TopCompatibility;
import zed.d0c.floormats.punchcards.PunchCards;
import zed.d0c.floormats.setup.ModSetup;
import zed.d0c.floormats.setup.Registration;

@Mod(value="floormats")
public class FloorMats {
    public static final String MODID = "floormats";

    public FloorMats() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        Registration.init(modEventBus);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarted);
        MinecraftForge.EVENT_BUS.addListener(this::serverStopped);
        MinecraftForge.EVENT_BUS.addListener(ModSetup::onPlayerLoggedIn);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SPEC);
        TopCompatibility.register();
    }

    public void serverStarted(ServerStartedEvent event) {
        ServerLevel world = event.getServer().m_129880_(Level.f_46428_);
        PunchCards worldData = (PunchCards)Objects.requireNonNull(world).m_8895_().m_164861_(PunchCards::load, PunchCards::new, PunchCards.getDataName());
        PunchCards.setInstance(worldData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serverStopped(ServerStoppedEvent event) {
        Clusters.ClustersRegistry clustersRegistry = Clusters.getClustersRegistry();
        synchronized (clustersRegistry) {
            Clusters.getClustersRegistry().clear();
        }
    }
}

