/*
 * Decompiled with CFR 0.152.
 */
package zed.d0c.floormats;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="floormats", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.BooleanValue ILLUMINATION = BUILDER.comment("Can inlayed floor mats be modified to emit light?").define("illumination", true);
    private static final ForgeConfigSpec.IntValue ENERGY_TRANSFER_LIMIT = BUILDER.comment("Max transfer rate of inlayed wood floor mats").defineInRange("energyTransferLimit", 64, 0, Integer.MAX_VALUE);
    private static final ForgeConfigSpec.BooleanValue ALLOW_WIRELESS_TRANSFER = BUILDER.comment("Allow linked inlayed floor mats to transmit energy wirelessly").define("allowWirelessTransfer", true);
    private static final ForgeConfigSpec.IntValue CREEPER_ENERGY = BUILDER.comment("Energy from Creepers").defineInRange("creeperEnergy", 1, 0, Integer.MAX_VALUE);
    private static final ForgeConfigSpec.IntValue CHARGED_CREEPER_ENERGY = BUILDER.comment("Energy from Charged Creepers").defineInRange("chargedCreeperEnergy", 8, 0, Integer.MAX_VALUE);
    static final ForgeConfigSpec SPEC = BUILDER.build();
    public static boolean illumination;
    public static int energyTransferLimit;
    public static boolean allowWirelessTransfer;
    public static int creeperEnergy;
    public static int chargedCreeperEnergy;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        illumination = (Boolean)ILLUMINATION.get();
        energyTransferLimit = (Integer)ENERGY_TRANSFER_LIMIT.get();
        allowWirelessTransfer = (Boolean)ALLOW_WIRELESS_TRANSFER.get();
        creeperEnergy = (Integer)CREEPER_ENERGY.get();
        chargedCreeperEnergy = (Integer)CHARGED_CREEPER_ENERGY.get();
    }
}

