/*
 * Decompiled with CFR 0.152.
 */
package com.nitespring.monsterplus.common.entity.projectiles;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class BloodySlashEntity
extends Entity {
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;
    private int lifeTicks = 18;
    private float damage = 4.0f;
    private static final EntityDataAccessor<Integer> ANIMATIONSTATE = SynchedEntityData.m_135353_(BloodySlashEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public BloodySlashEntity(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    public BloodySlashEntity(EntityType<?> p_19870_, Level p_19871_, Vec3 pos, float dmg, float rot) {
        this(p_19870_, p_19871_);
        this.m_146884_(pos);
        this.damage = dmg;
        this.m_146922_(rot * 57.295776f);
    }

    public int getAnimationState() {
        return (Integer)this.f_19804_.m_135370_(ANIMATIONSTATE);
    }

    public void setAnimationState(int anim) {
        this.f_19804_.m_135381_(ANIMATIONSTATE, (Object)anim);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ANIMATIONSTATE, (Object)0);
    }

    protected void m_7378_(CompoundTag p_20052_) {
        if (p_20052_.m_128403_("Owner")) {
            this.ownerUUID = p_20052_.m_128342_("Owner");
        }
    }

    protected void m_7380_(CompoundTag p_20139_) {
        if (this.ownerUUID != null) {
            p_20139_.m_128362_("Owner", this.ownerUUID);
        }
    }

    public void setOwner(@Nullable LivingEntity p_36939_) {
        this.owner = p_36939_;
        this.ownerUUID = p_36939_ == null ? null : p_36939_.m_20148_();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.m_20193_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_20193_()).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public boolean m_5825_() {
        return true;
    }

    public void m_8119_() {
        super.m_8119_();
        --this.lifeTicks;
        if (this.lifeTicks == 16 || this.lifeTicks == 14 || this.lifeTicks == 12) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12317_, this.m_5720_(), 0.25f, this.f_19796_.m_188501_() * 0.2f + 1.0f, false);
            this.setAnimationState(this.getAnimationState() + 1);
        }
        if (this.lifeTicks == 8) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12278_, this.m_5720_(), 0.5f, this.f_19796_.m_188501_() * 0.2f + 2.85f, false);
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12317_, this.m_5720_(), 1.0f, this.f_19796_.m_188501_() * 0.2f + 0.15f, false);
            this.setAnimationState(this.getAnimationState() + 1);
            for (LivingEntity livingentity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(1.2, 0.0, 1.2))) {
                this.dealDamageTo(livingentity);
            }
            for (int i = 0; i < 48; ++i) {
                double d0 = this.m_20185_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
                double d1 = this.m_20186_() - 0.75 + this.f_19796_.m_188500_() * 1.5;
                double d2 = this.m_20189_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
                double d3 = (this.f_19796_.m_188500_() * 2.0 - 1.0) * 0.75;
                double d4 = 0.15 + this.f_19796_.m_188500_() * 0.6;
                double d5 = (this.f_19796_.m_188500_() * 2.0 - 1.0) * 0.75;
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50451_.m_49966_()), d0, d1 + 1.0, d2, d3, d4, d5);
            }
        }
        if (this.lifeTicks < 0) {
            this.m_146870_();
        }
    }

    private void dealDamageTo(LivingEntity p_36945_) {
        LivingEntity livingentity = this.getOwner();
        if (p_36945_.m_6084_() && !p_36945_.m_20147_() && p_36945_ != livingentity) {
            if (livingentity == null) {
                p_36945_.m_6469_(this.m_9236_().m_269111_().m_269264_(), this.damage);
            } else {
                if (livingentity.m_7307_((Entity)p_36945_)) {
                    return;
                }
                p_36945_.m_6469_(this.m_9236_().m_269111_().m_269333_(livingentity), this.damage);
            }
        }
    }
}

