/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.network.messages.IMessage;
import com.ldtteam.structurize.storage.ClientStructurePackLoader;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class TransferStructurePackToClient
implements IMessage {
    private final ByteBuf payload;
    private final String packname;
    private final boolean eol;

    public TransferStructurePackToClient(FriendlyByteBuf buf) {
        this.packname = buf.m_130136_(Short.MAX_VALUE);
        this.eol = buf.readBoolean();
        this.payload = Unpooled.wrappedBuffer((byte[])buf.m_130052_());
    }

    public TransferStructurePackToClient(String packName, ByteBuf payload, boolean eol) {
        this.packname = packName;
        this.payload = payload;
        this.eol = eol;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130070_(this.packname);
        buf.writeBoolean(this.eol);
        buf.m_130087_(this.payload.array());
        this.payload.release();
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        if (!isLogicalServer) {
            ClientStructurePackLoader.onStructurePackTransfer(this.packname, this.payload, this.eol);
        }
    }
}

