/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.forge.core.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.satisfy.vinery.core.util.VillagerUtil;
import net.satisfy.vinery.forge.core.config.VineryForgeConfig;
import net.satisfy.vinery.forge.core.registry.VineryForgeVillagers;

@Mod.EventBusSubscriber(modid="vinery")
public class VineryForgeEventhandler {
    public VineryForgeEventhandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public static void addCustomTrades(VillagerTradesEvent event) {
        if (event.getType().equals(VineryForgeVillagers.WINEMAKER.get())) {
            HashMap<Integer, List<VillagerTrades.ItemListing>> trades = new HashMap<Integer, List<VillagerTrades.ItemListing>>();
            VineryForgeEventhandler.loadTradesFromConfig(trades, (List)VineryForgeConfig.LEVEL1_TRADES.get(), 1);
            VineryForgeEventhandler.loadTradesFromConfig(trades, (List)VineryForgeConfig.LEVEL2_TRADES.get(), 2);
            VineryForgeEventhandler.loadTradesFromConfig(trades, (List)VineryForgeConfig.LEVEL3_TRADES.get(), 3);
            VineryForgeEventhandler.loadTradesFromConfig(trades, (List)VineryForgeConfig.LEVEL4_TRADES.get(), 4);
            VineryForgeEventhandler.loadTradesFromConfig(trades, (List)VineryForgeConfig.LEVEL5_TRADES.get(), 5);
            event.getTrades().clear();
            event.getTrades().putAll(trades);
        }
    }

    private static void loadTradesFromConfig(Map<Integer, List<VillagerTrades.ItemListing>> trades, List<? extends String> configList, int level) {
        ArrayList<VillagerUtil.SellItemFactory> tradeList = new ArrayList<VillagerUtil.SellItemFactory>();
        for (String string : configList) {
            String[] parts = string.split("\\|");
            if (parts.length != 5) continue;
            String itemName = parts[0];
            int price = Integer.parseInt(parts[1]);
            int quantity = Integer.parseInt(parts[2]);
            int maxUses = Integer.parseInt(parts[3]);
            boolean isSelling = Boolean.parseBoolean(parts[4]);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
            if (item == null) continue;
            Object listing = isSelling ? new VillagerUtil.SellItemFactory(item, price, quantity, maxUses) : new VillagerUtil.BuyForOneEmeraldFactory((ItemLike)item, price, quantity, maxUses);
            tradeList.add((VillagerUtil.SellItemFactory)listing);
        }
        trades.put(level, tradeList);
    }
}

