/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.sootychimneys;

import io.github.mortuusars.sootychimneys.block.ChimneyBlock;
import io.github.mortuusars.sootychimneys.config.Config;
import io.github.mortuusars.sootychimneys.core.Smoke;
import io.github.mortuusars.sootychimneys.core.WindGetter;
import io.github.mortuusars.sootychimneys.integration.create.CreateIntegration;
import io.github.mortuusars.sootychimneys.setup.Registry;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;

@Mod(value="sootychimneys")
public class SootyChimneys {
    public static final String MOD_ID = "sootychimneys";
    public static final Random RANDOM = new Random();

    public SootyChimneys() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        Registry.init();
        MinecraftForge.EVENT_BUS.addListener(WindGetter::onPlayerTick);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
    }

    public static ResourceLocation resource(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        if (ModList.get().isLoaded("create")) {
            CreateIntegration.registerMovingBehaviors();
        }
    }

    public static enum Chimney {
        BRICK("brick", new Smoke(0.5f, 1.0f, 0.5f, 0.25f, 0.1f, 0.25f).setSpeed(1.2f), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)11.0, (double)15.0), (VoxelShape)Block.m_49796_((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), 0.75f),
        COBBLESTONE("cobblestone", new Smoke(0.5f, 1.15f, 0.5f, 0.25f, 0.1f, 0.25f), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (VoxelShape)Block.m_49796_((double)1.0, (double)4.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0)), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), 0.75f),
        STONE_BRICK("stone_brick", new Smoke(0.5f, 1.2f, 0.5f, 0.025f, 0.05f, 0.025f).setIntensity(0.6f), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)11.0, (double)12.0), (VoxelShape)Block.m_49796_((double)3.0, (double)11.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0)), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), 0.75f),
        MUD_BRICK("mud_brick", new Smoke(0.5f, 1.0f, 0.5f, 0.15f, 0.1f, 0.15f).setSpeed(1.1f), Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)8.0, (double)11.0), Block.m_49796_((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)8.0, (double)16.0)}), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0, (double)11.0), (VoxelShape)Block.m_49796_((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)16.0)), 0.75f),
        IRON("iron", new Smoke(0.5f, 1.2f, 0.5f, 0.05f, 0.05f, 0.05f).setIntensity(0.6f).setSpeed(1.35f), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)15.0, (double)11.0), (VoxelShape)Block.m_49796_((double)4.0, (double)7.0, (double)4.0, (double)12.0, (double)15.0, (double)12.0)), Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), 0.5f),
        COPPER("copper", new Smoke(0.5f, 1.25f, 0.5f, 0.025f, 0.05f, 0.025f).setIntensity(0.5f).setSpeed(1.2f), Shapes.m_83124_((VoxelShape)Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)4.0, (double)11.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), Block.m_49796_((double)5.0, (double)10.0, (double)5.0, (double)11.0, (double)14.0, (double)11.0)}), Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), 0.5f),
        TERRACOTTA("terracotta", new Smoke(0.5f, 0.75f, 0.5f, 0.02f, 0.05f, 0.02f).setIntensity(0.2f).setSpeed(0.65f), Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0), Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), 0.5f);

        private final String typeId;
        private final String cleanId;
        private final String dirtyId;
        private final Smoke smoke;
        private final VoxelShape defaultShape;
        private final VoxelShape stackedShape;
        private final float defaultScrapeChance;

        private Chimney(String typeId, Smoke smoke, VoxelShape defaultShape, VoxelShape stackedShape, float defaultScrapeChance) {
            this.typeId = typeId;
            this.smoke = smoke;
            this.defaultShape = defaultShape;
            this.stackedShape = stackedShape;
            this.defaultScrapeChance = defaultScrapeChance;
            this.cleanId = typeId + "_chimney";
            this.dirtyId = "dirty_" + typeId + "_chimney";
        }

        public String typeId() {
            return this.typeId;
        }

        public String getCleanId() {
            return this.cleanId;
        }

        public String getDirtyId() {
            return this.dirtyId;
        }

        public Smoke getSmoke() {
            return this.smoke;
        }

        public VoxelShape getDefaultShape() {
            return this.defaultShape;
        }

        public VoxelShape getStackedShape() {
            return this.stackedShape;
        }

        public float getDefaultScrapeChance() {
            return this.defaultScrapeChance;
        }

        public ChimneyBlock getCleanBlock() {
            return (ChimneyBlock)((Object)ForgeRegistries.BLOCKS.getValue(SootyChimneys.resource(this.getCleanId())));
        }

        public ChimneyBlock getDirtyBlock() {
            return (ChimneyBlock)((Object)ForgeRegistries.BLOCKS.getValue(SootyChimneys.resource(this.getDirtyId())));
        }

        public Item getCleanItem() {
            return (Item)ForgeRegistries.ITEMS.getValue(SootyChimneys.resource(this.getCleanId()));
        }

        public Item getDirtyItem() {
            return (Item)ForgeRegistries.ITEMS.getValue(SootyChimneys.resource(this.getDirtyId()));
        }
    }
}

