/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.signal;

import java.util.EnumMap;
import java.util.Map;
import mods.railcraft.util.VoxelShapeUtil;
import mods.railcraft.world.level.block.post.PostBlock;
import mods.railcraft.world.level.block.signal.SignalBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class SingleSignalBlock
extends SignalBlock {
    public static final BooleanProperty DOWN = BlockStateProperties.f_61367_;
    public static final VoxelShape SHAPE = SingleSignalBlock.m_49796_((double)3.0, (double)6.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    public static final VoxelShape POST_SHAPE = SingleSignalBlock.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);

    public SingleSignalBlock(BlockBehaviour.Properties properties) {
        super(SHAPE, SingleSignalBlock.createConnectionShapes(), properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    private static Map<Direction, VoxelShape> createConnectionShapes() {
        EnumMap<Direction, VoxelShape> connectionShapes = new EnumMap<Direction, VoxelShape>(Direction.class);
        connectionShapes.putAll(PostBlock.HORIZONTAL_CONNECTION_SHAPES);
        connectionShapes.put(Direction.DOWN, POST_SHAPE);
        return connectionShapes;
    }

    @Override
    protected int computeShapeIndex(BlockState blockState) {
        int i = super.computeShapeIndex(blockState);
        if (((Boolean)blockState.m_61143_((Property)DOWN)).booleanValue()) {
            i |= VoxelShapeUtil.indexFor(Direction.DOWN);
        }
        return i;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{DOWN});
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction facing = context.m_8125_().m_122424_();
        BlockPos downPos = pos.m_7495_();
        BlockState downState = level.m_8055_(downPos);
        return (BlockState)super.m_5573_(context).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(this.connectsTo(downState, downState.m_60783_((BlockGetter)level, downPos, Direction.UP), Direction.DOWN, facing)));
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor world, BlockPos pos, BlockPos newPos) {
        state = super.m_7417_(state, direction, newState, world, pos, newPos);
        return direction == Direction.DOWN ? (BlockState)state.m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(this.connectsTo(newState, newState.m_60783_((BlockGetter)world, newPos, direction.m_122424_()), direction, (Direction)state.m_61143_((Property)FACING)))) : state;
    }
}

