/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.signal;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import mods.railcraft.tags.RailcraftTags;
import mods.railcraft.util.LevelUtil;
import mods.railcraft.util.VoxelShapeUtil;
import mods.railcraft.world.level.block.entity.signal.AbstractSignalBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class SignalBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty NORTH = PipeBlock.f_55148_;
    public static final BooleanProperty EAST = PipeBlock.f_55149_;
    public static final BooleanProperty SOUTH = PipeBlock.f_55150_;
    public static final BooleanProperty WEST = PipeBlock.f_55151_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final Map<Direction, BooleanProperty> propertyByDirection = Map.of(Direction.NORTH, NORTH, Direction.EAST, EAST, Direction.SOUTH, SOUTH, Direction.WEST, WEST);
    private final VoxelShape[] shapes;
    protected final Object2IntMap<BlockState> stateToIndex = new Object2IntOpenHashMap();

    protected SignalBlock(VoxelShape shape, Map<Direction, VoxelShape> connectionShapes, BlockBehaviour.Properties properties) {
        super(properties);
        this.shapes = VoxelShapeUtil.makeShapes(shape, connectionShapes);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, EAST, WEST, SOUTH, FACING, WATERLOGGED});
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter level, BlockPos blockPos, CollisionContext context) {
        return this.shapes[this.getShapeIndex(blockState)];
    }

    public final int getShapeIndex(BlockState blockState) {
        return this.stateToIndex.computeIfAbsent((Object)blockState, this::computeShapeIndex);
    }

    protected int computeShapeIndex(BlockState blockState) {
        int i = 0;
        for (Map.Entry<Direction, BooleanProperty> entry : propertyByDirection.entrySet()) {
            if (!((Boolean)blockState.m_61143_((Property)entry.getValue())).booleanValue()) continue;
            i |= VoxelShapeUtil.indexFor(entry.getKey());
        }
        return i;
    }

    public boolean m_7420_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) == false;
    }

    public int m_7753_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return LevelUtil.getBlockEntity(blockGetter, blockPos, AbstractSignalBlockEntity.class).map(AbstractSignalBlockEntity::getLightValue).orElseGet(() -> super.m_7753_(blockState, blockGetter, blockPos));
    }

    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)blockState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        FluidState fluidState = level.m_6425_(pos);
        Direction facing = context.m_8125_().m_122424_();
        BlockPos northPos = pos.m_122012_();
        BlockPos southPos = pos.m_122019_();
        BlockPos westPos = pos.m_122024_();
        BlockPos eastPos = pos.m_122029_();
        BlockState northState = level.m_8055_(northPos);
        BlockState southState = level.m_8055_(southPos);
        BlockState westState = level.m_8055_(westPos);
        BlockState eastState = level.m_8055_(eastPos);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(this.connectsTo(northState, northState.m_60783_((BlockGetter)level, northPos, Direction.SOUTH), Direction.NORTH, facing)))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(this.connectsTo(southState, southState.m_60783_((BlockGetter)level, southPos, Direction.NORTH), Direction.SOUTH, facing)))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(this.connectsTo(westState, westState.m_60783_((BlockGetter)level, westPos, Direction.EAST), Direction.WEST, facing)))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(this.connectsTo(eastState, eastState.m_60783_((BlockGetter)level, eastPos, Direction.WEST), Direction.EAST, facing)))).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor world, BlockPos pos, BlockPos newPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return direction.m_122434_().m_122479_() ? (BlockState)state.m_61124_((Property)propertyByDirection.get(direction), (Comparable)Boolean.valueOf(this.connectsTo(newState, newState.m_60783_((BlockGetter)world, newPos, direction.m_122424_()), direction, (Direction)state.m_61143_((Property)FACING)))) : state;
    }

    public boolean connectsTo(BlockState blockState, boolean faceStudry, Direction direction, Direction facing) {
        if (facing == direction) {
            return false;
        }
        if (blockState.m_204336_(RailcraftTags.Blocks.SIGNAL)) {
            return SignalBlock.connectsToDirection(blockState, direction);
        }
        if (blockState.m_204336_(RailcraftTags.Blocks.POST)) {
            return true;
        }
        if (SignalBlock.m_152463_((BlockState)blockState) || !faceStudry) {
            return false;
        }
        if (blockState.m_204336_(BlockTags.f_13039_) || blockState.m_204336_(BlockTags.f_13032_)) {
            return direction.m_122434_().m_122480_() != Direction.Plane.HORIZONTAL;
        }
        return true;
    }

    public static boolean connectsToDirection(BlockState blockState, Direction direction) {
        return direction.m_122434_().m_122478_() || direction.m_122424_() != blockState.m_61143_((Property)FACING);
    }
}

