/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.manipulator;

import java.util.Collection;
import java.util.function.Predicate;
import mods.railcraft.RailcraftConfig;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.item.MinecartFactory;
import mods.railcraft.util.EntitySearcher;
import mods.railcraft.util.ItemStackKey;
import mods.railcraft.util.container.AdvancedContainer;
import mods.railcraft.util.container.ContainerManifest;
import mods.railcraft.world.entity.vehicle.MinecartUtil;
import mods.railcraft.world.inventory.TrainDispenserMenu;
import mods.railcraft.world.item.CartItem;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.manipulator.CartDispenserBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MinecartItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class TrainDispenserBlockEntity
extends CartDispenserBlockEntity {
    private static final int PATTERN_SIZE = 9;
    private static final int BUFFER_SIZE = 18;
    private final AdvancedContainer invPattern = new AdvancedContainer(9).listener(this).phantom();
    private byte patternIndex;
    private boolean spawningTrain;
    @Nullable
    private RollingStock lastCart;

    public TrainDispenserBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.TRAIN_DISPENSER.get(), blockPos, blockState);
        this.setContainerSize(18);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TrainDispenserBlockEntity blockEntity) {
        if (blockEntity.spawningTrain && blockEntity.timeSinceLastSpawn % 4 == 0) {
            blockEntity.spawnNextCart((ServerLevel)level);
        }
        ++blockEntity.timeSinceLastSpawn;
    }

    private boolean spawnNextCart(ServerLevel serverLevel) {
        ItemStack cartItem;
        ItemStack spawn = this.invPattern.m_8020_(this.patternIndex);
        if (spawn.m_41619_()) {
            this.resetSpawnSequence();
            return false;
        }
        Predicate<ItemStack> filter = itemStack -> TrainDispenserBlockEntity.testMinecart(spawn, itemStack);
        if (this.countItems(filter) == 0) {
            this.resetSpawnSequence();
            return false;
        }
        BlockPos offset = this.m_58899_().m_121955_(this.getFacing().m_122436_());
        if (EntitySearcher.findMinecarts().at(offset).list((Level)serverLevel).isEmpty() && !(cartItem = this.extract(filter)).m_41619_()) {
            AbstractMinecart placedCart = MinecartUtil.placeCart(cartItem, serverLevel, offset);
            if (placedCart != null) {
                RollingStock extension = RollingStock.getOrThrow(placedCart);
                if (this.lastCart != null) {
                    extension.link(this.lastCart);
                }
                this.lastCart = extension;
                this.patternIndex = (byte)(this.patternIndex + 1);
                if (this.patternIndex >= this.invPattern.m_6643_()) {
                    this.resetSpawnSequence();
                }
                return true;
            }
            this.insert(cartItem);
        }
        return false;
    }

    private void resetSpawnSequence() {
        this.patternIndex = 0;
        this.spawningTrain = false;
        this.timeSinceLastSpawn = 0;
        this.lastCart = null;
    }

    @Override
    protected void onPulse(ServerLevel serverLevel) {
        boolean empty = EntitySearcher.findMinecarts().at(this.m_58899_().m_121955_(this.getFacing().m_122436_())).list((Level)serverLevel).isEmpty();
        if (!empty) {
            return;
        }
        if (!this.spawningTrain && this.canBuildTrain() && this.timeSinceLastSpawn > (Integer)RailcraftConfig.SERVER.cartDispenserDelay.get() * 20) {
            this.spawningTrain = true;
        }
    }

    private boolean canBuildTrain() {
        ContainerManifest pattern = ContainerManifest.create(this.invPattern);
        ContainerManifest buffer = ContainerManifest.create(this.container(), (Collection<ItemStackKey>)pattern.keySet());
        return pattern.values().stream().anyMatch(e -> buffer.count(e.key()) >= e.count());
    }

    public AdvancedContainer getInvPattern() {
        return this.invPattern;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("trainDispenserFilters", (Tag)this.invPattern.m_7927_());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.invPattern.m_7797_(tag.m_128437_("trainDispenserFilters", 10));
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new TrainDispenserMenu(id, inventory, this);
    }

    private static boolean testMinecart(ItemStack original, ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return false;
        }
        Item item = itemStack.m_41720_();
        if (item instanceof MinecartItem || item instanceof MinecartFactory || item instanceof CartItem) {
            return original.m_150930_(item);
        }
        return false;
    }
}

