/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import mods.railcraft.util.JsonUtil;
import mods.railcraft.world.item.crafting.RailcraftRecipeSerializers;
import mods.railcraft.world.item.crafting.RailcraftRecipeTypes;
import mods.railcraft.world.level.block.RailcraftBlocks;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;

public class BlastFurnaceRecipe
extends AbstractCookingRecipe {
    private final int slagOutput;

    public BlastFurnaceRecipe(ResourceLocation id, Ingredient ingredient, ItemStack result, float experience, int cookingTime, int slagOutput) {
        super((RecipeType)RailcraftRecipeTypes.BLASTING.get(), id, "", CookingBookCategory.MISC, ingredient, result, experience, cookingTime);
        this.slagOutput = slagOutput;
    }

    public int getSlagOutput() {
        return this.slagOutput;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RailcraftRecipeSerializers.BLASTING.get();
    }

    public boolean m_5598_() {
        return true;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)RailcraftBlocks.BLAST_FURNACE_BRICKS.get());
    }

    public static class Serializer
    implements RecipeSerializer<BlastFurnaceRecipe> {
        public BlastFurnaceRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            int cookingTime = GsonHelper.m_13824_((JsonObject)json, (String)"cookingTime", (int)400);
            int slagOutput = GsonHelper.m_13824_((JsonObject)json, (String)"slagOutput", (int)0);
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)json.get("ingredient"));
            ItemStack result = JsonUtil.itemFromJson(GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            float experience = GsonHelper.m_13820_((JsonObject)json, (String)"experience", (float)0.0f);
            return new BlastFurnaceRecipe(recipeId, ingredient, result, experience, cookingTime, slagOutput);
        }

        public BlastFurnaceRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int slagOutput = buffer.m_130242_();
            int cookingTime = buffer.m_130242_();
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack result = buffer.m_130267_();
            float experience = buffer.readFloat();
            return new BlastFurnaceRecipe(recipeId, ingredient, result, experience, cookingTime, slagOutput);
        }

        public void toNetwork(FriendlyByteBuf buffer, BlastFurnaceRecipe recipe) {
            buffer.m_130130_(recipe.slagOutput);
            buffer.m_130130_(recipe.f_43732_);
            recipe.f_43729_.m_43923_(buffer);
            buffer.m_130055_(recipe.f_43730_);
            buffer.writeFloat(recipe.f_43731_);
        }
    }
}

