/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.inventory.detector;

import mods.railcraft.gui.widget.Widget;
import mods.railcraft.world.inventory.RailcraftMenu;
import mods.railcraft.world.inventory.RailcraftMenuTypes;
import mods.railcraft.world.item.RoutingTableBookItem;
import mods.railcraft.world.level.block.entity.detector.RoutingDetectorBlockEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class RoutingDetectorMenu
extends RailcraftMenu {
    private final Widget error;
    private final RoutingDetectorBlockEntity blockEntity;

    public RoutingDetectorMenu(int id, Inventory inventory, final RoutingDetectorBlockEntity blockEntity) {
        super((MenuType)RailcraftMenuTypes.ROUTING_DETECTOR.get(), id, inventory.f_35978_, blockEntity::isStillValid);
        this.blockEntity = blockEntity;
        Slot routingTableBookSlot = new Slot(blockEntity, 0, 35, 24){

            public boolean m_5857_(ItemStack stack) {
                return RoutingTableBookItem.FILTER.test(stack) && stack.m_41613_() == 1;
            }

            public boolean m_8010_(Player player) {
                return blockEntity.canAccess(player.m_36316_());
            }

            public boolean m_150651_(Player player) {
                if (blockEntity.canAccess(player.m_36316_())) {
                    return super.m_150651_(player);
                }
                return false;
            }

            public void m_6654_() {
                super.m_6654_();
                blockEntity.resetLogic();
                RoutingDetectorMenu.this.error.hidden = blockEntity.logicError().isEmpty();
            }
        };
        this.error = new Widget(16, 24, 176, 0, 16, 16);
        this.addWidget(this.error);
        this.m_38897_(routingTableBookSlot);
        this.addInventorySlots(inventory, 160);
    }

    public RoutingDetectorBlockEntity getRoutingDetector() {
        return this.blockEntity;
    }

    public Widget getErrorWidget() {
        return this.error;
    }
}

