/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity.vehicle;

import mods.railcraft.api.item.PrototypedItem;
import mods.railcraft.util.container.AdvancedContainer;
import mods.railcraft.world.entity.vehicle.RailcraftMinecart;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class FilteredMinecart
extends RailcraftMinecart {
    private static final EntityDataAccessor<ItemStack> FILTER = SynchedEntityData.m_135353_(FilteredMinecart.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private final AdvancedContainer filterContainer = new AdvancedContainer(1).listener((Container)this).phantom();

    protected FilteredMinecart(EntityType<?> type, Level level) {
        super(type, level);
    }

    protected FilteredMinecart(ItemStack itemStack, EntityType<?> type, double x, double y, double z, Level level) {
        super(itemStack, type, x, y, z, level);
        this.setFilter(FilteredMinecart.getFilterFromCartItem(itemStack));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FILTER, (Object)ItemStack.f_41583_);
    }

    private static ItemStack getFilterFromCartItem(ItemStack cartStack) {
        ItemStack itemStack;
        Item item = cartStack.m_41720_();
        if (item instanceof PrototypedItem) {
            PrototypedItem prototypedItem = (PrototypedItem)item;
            itemStack = prototypedItem.getPrototype(cartStack);
        } else {
            itemStack = ItemStack.f_41583_;
        }
        return itemStack;
    }

    private static ItemStack addFilterToCartItem(ItemStack cartStack, ItemStack filterStack) {
        Item item;
        if (!filterStack.m_41619_() && (item = cartStack.m_41720_()) instanceof PrototypedItem) {
            PrototypedItem prototypedItem = (PrototypedItem)item;
            prototypedItem.setPrototype(cartStack, filterStack);
        }
        return cartStack;
    }

    @Override
    public ItemStack m_142340_() {
        return FilteredMinecart.addFilterToCartItem(super.m_142340_(), this.getFilterItem());
    }

    @Override
    public boolean canBeRidden() {
        return false;
    }

    @Override
    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.filterContainer.m_7797_(tag.m_128437_("filter", 10));
        this.f_19804_.m_135381_(FILTER, (Object)this.getFilterInv().m_8020_(0));
    }

    @Override
    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128365_("filter", (Tag)this.filterContainer.m_7927_());
    }

    public boolean hasFilter() {
        return !this.getFilterItem().m_41619_();
    }

    public ItemStack getFilterItem() {
        return (ItemStack)this.f_19804_.m_135370_(FILTER);
    }

    public AdvancedContainer getFilterInv() {
        return this.filterContainer;
    }

    public void setFilter(ItemStack filter) {
        this.getFilterInv().m_6836_(0, filter);
    }

    public void m_6596_() {
        super.m_6596_();
        this.f_19804_.m_135381_(FILTER, (Object)this.getFilterInv().m_8020_(0));
    }
}

