/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.util;

import java.util.Optional;
import mods.railcraft.api.core.RailcraftFakePlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;

public class LevelUtil {
    @Nullable
    public static BlockEntity getBlockEntityWeak(Level level, BlockPos pos) {
        return level.m_46749_(pos) ? level.m_7702_(pos) : null;
    }

    public static Optional<BlockEntity> getBlockEntity(Level level, BlockPos pos) {
        return Optional.ofNullable(level.m_7702_(pos));
    }

    public static <T> Optional<T> getBlockEntity(BlockGetter getter, BlockPos pos, Class<T> blockEntityType) {
        return Optional.ofNullable(getter.m_7702_(pos)).filter(blockEntityType::isInstance).map(blockEntityType::cast);
    }

    public static boolean setBlockState(Level level, BlockPos pos, BlockState blockState, @Nullable Entity entity) {
        if (entity == null) {
            entity = RailcraftFakePlayer.get((ServerLevel)level, pos);
        }
        BlockSnapshot snapshot = BlockSnapshot.create((ResourceKey)level.m_46472_(), (LevelAccessor)level, (BlockPos)pos);
        boolean result = level.m_46597_(pos, blockState);
        if (ForgeEventFactory.onBlockPlace((Entity)entity, (BlockSnapshot)snapshot, (Direction)Direction.UP)) {
            snapshot.restore(true, false);
            return false;
        }
        return result;
    }

    public static boolean setBlockStateWorldGen(Level level, BlockPos pos, BlockState blockState) {
        return level.m_7731_(pos, blockState, 3);
    }

    public static boolean setAir(Level level, BlockPos pos) {
        return level.m_46597_(pos, Blocks.f_50016_.m_49966_());
    }

    public static boolean destroyBlock(Level level, BlockPos pos) {
        return level.m_46961_(pos, level.m_46469_().m_46207_(GameRules.f_46136_));
    }

    public static boolean destroyBlock(Level level, BlockPos pos, @Nullable Player actor) {
        return LevelUtil.destroyBlock(level, pos, actor, level.m_46469_().m_46207_(GameRules.f_46136_));
    }

    public static boolean destroyBlock(Level level, BlockPos pos, @Nullable Player actor, boolean dropBlock) {
        if (actor == null) {
            actor = RailcraftFakePlayer.get((ServerLevel)level, pos);
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(level, pos, level.m_8055_(pos), actor))) {
            return false;
        }
        return level.m_46961_(pos, dropBlock);
    }

    public static boolean playerRemoveBlock(Level level, BlockPos pos, @Nullable Player player) {
        return LevelUtil.playerRemoveBlock(level, pos, player, level.m_46469_().m_46207_(GameRules.f_46136_));
    }

    public static boolean playerRemoveBlock(Level level, BlockPos pos, @Nullable Player player, boolean dropBlock) {
        if (player == null) {
            player = RailcraftFakePlayer.get((ServerLevel)level, pos);
        }
        BlockState blockState = level.m_8055_(pos);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(level, pos, blockState, player))) {
            return false;
        }
        if (!blockState.onDestroyedByPlayer(level, pos, player, dropBlock, level.m_6425_(pos))) {
            return false;
        }
        if (dropBlock) {
            blockState.m_60734_().m_6240_(level, player, pos, blockState, blockEntity, player.m_21205_());
        }
        return true;
    }

    public static void spewItem(ItemStack stack, Level level, double x, double y, double z) {
        if (stack.m_41619_()) {
            return;
        }
        float xOffset = level.f_46441_.m_188501_() * 0.8f + 0.1f;
        float yOffset = level.f_46441_.m_188501_() * 0.8f + 0.1f;
        float zOffset = level.f_46441_.m_188501_() * 0.8f + 0.1f;
        while (!stack.m_41619_()) {
            int numToDrop = Math.min(level.f_46441_.m_188503_(21) + 10, stack.m_41613_());
            ItemStack newStack = stack.m_41620_(numToDrop);
            ItemEntity itemEntity = new ItemEntity(level, x + (double)xOffset, y + (double)yOffset, z + (double)zOffset, newStack);
            level.m_7967_((Entity)itemEntity);
        }
    }
}

