/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.network.play;

import com.mojang.authlib.GameProfile;
import java.util.EnumSet;
import java.util.function.Supplier;
import mods.railcraft.api.signal.SignalAspect;
import mods.railcraft.util.LevelUtil;
import mods.railcraft.world.level.block.entity.signal.ActionSignalBoxBlockEntity;
import mods.railcraft.world.level.block.entity.signal.LockableSignalBoxBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public record SetActionSignalBoxAttributesMessage(BlockPos blockPos, EnumSet<SignalAspect> actionSignalAspects, LockableSignalBoxBlockEntity.Lock lock) {
    public void encode(FriendlyByteBuf out) {
        out.m_130064_(this.blockPos);
        out.m_245616_(this.actionSignalAspects, SignalAspect.class);
        out.m_130068_((Enum)this.lock);
    }

    public static SetActionSignalBoxAttributesMessage decode(FriendlyByteBuf in) {
        BlockPos blockPos = in.m_130135_();
        EnumSet actionSignalAspects = in.m_247336_(SignalAspect.class);
        LockableSignalBoxBlockEntity.Lock lock = (LockableSignalBoxBlockEntity.Lock)in.m_130066_(LockableSignalBoxBlockEntity.Lock.class);
        return new SetActionSignalBoxAttributesMessage(blockPos, actionSignalAspects, lock);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        Level level = context.get().getSender().m_9236_();
        GameProfile senderProfile = context.get().getSender().m_36316_();
        LevelUtil.getBlockEntity((BlockGetter)level, this.blockPos, ActionSignalBoxBlockEntity.class).filter(signalBox -> signalBox.canAccess(senderProfile)).ifPresent(signalBox -> {
            signalBox.getActionSignalAspects().clear();
            signalBox.getActionSignalAspects().addAll(this.actionSignalAspects);
            signalBox.setLock(this.lock);
            signalBox.setOwner((GameProfile)(this.lock == LockableSignalBoxBlockEntity.Lock.LOCKED ? senderProfile : null));
            signalBox.syncToClient();
            signalBox.m_6596_();
        });
        return true;
    }
}

