/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.integrations.jei.category;

import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mods.railcraft.Translations;
import mods.railcraft.integrations.jei.RecipeTypes;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.crafting.RollingRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class RollingRecipeCategory
implements IRecipeCategory<RollingRecipe> {
    private static final int WIDTH = 116;
    private static final int HEIGHT = 54;
    private static final ResourceLocation CRAFTING_TABLE = new ResourceLocation("textures/gui/container/crafting_table.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final ICraftingGridHelper craftingGridHelper;

    public RollingRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(CRAFTING_TABLE, 29, 16, 116, 54);
        ItemStack itemStack = new ItemStack((ItemLike)RailcraftItems.MANUAL_ROLLING_MACHINE.get());
        this.icon = guiHelper.createDrawableItemStack(itemStack);
        this.craftingGridHelper = guiHelper.createCraftingGridHelper();
    }

    public RecipeType<RollingRecipe> getRecipeType() {
        return RecipeTypes.ROLLING_MACHINE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)Translations.Jei.METAL_ROLLING);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RollingRecipe recipe, IFocusGroup focuses) {
        RegistryAccess registryAccess = Minecraft.m_91087_().f_91073_.m_9598_();
        this.craftingGridHelper.createAndSetOutputs(builder, List.of(recipe.m_8043_(registryAccess)));
        int width = recipe.getWidth();
        int height = recipe.getHeight();
        List<List> inputs = recipe.m_7527_().stream().map(ingredient -> List.of(ingredient.m_43908_())).toList();
        this.craftingGridHelper.createAndSetInputs(builder, inputs, width, height);
    }
}

