/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.particle;

import mods.railcraft.api.signal.SignalUtil;
import mods.railcraft.client.particle.DimmableParticle;
import mods.railcraft.particle.TuningAuraParticleOptions;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class TuningAuraParticle
extends DimmableParticle {
    private final Vec3 destination;
    private final Vec3 source;

    private TuningAuraParticle(ClientLevel level, double x, double y, double z, double dx, double dy, double dz, TuningAuraParticleOptions options, SpriteSet sprites) {
        super(level, x, y, z, dx, dy, dz);
        this.destination = options.destination();
        this.source = new Vec3(x, y, z);
        this.calculateVector();
        this.m_6569_(0.5f);
        int color = options.color();
        float variant = this.f_107223_.m_188501_() * 0.6f + 0.4f;
        this.f_107227_ = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f * variant;
        this.f_107228_ = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f * variant;
        this.f_107229_ = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f * variant;
        this.m_107257_(2000);
        this.f_107219_ = false;
        this.m_108335_(sprites);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    private void calculateVector() {
        Vec3 vecParticle = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
        Vec3 vel = this.destination.m_82546_(vecParticle);
        vel = vel.m_82541_();
        float velScale = 0.1f;
        this.f_107215_ = vel.f_82479_ * (double)velScale;
        this.f_107216_ = vel.f_82480_ * (double)velScale;
        this.f_107217_ = vel.f_82481_ * (double)velScale;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (!SignalUtil.tuningAuraHandler().isTuningAuraActive()) {
            this.m_107274_();
            return;
        }
        if (!this.f_107208_.m_46749_(BlockPos.m_274446_((Position)this.source)) || !this.f_107208_.m_46749_(BlockPos.m_274446_((Position)this.destination))) {
            this.m_107274_();
        }
        BlockEntity sourceBE = this.f_107208_.m_7702_(BlockPos.m_274446_((Position)this.source));
        BlockEntity destBE = this.f_107208_.m_7702_(BlockPos.m_274446_((Position)this.source));
        if (sourceBE == null || sourceBE.m_58901_() || destBE == null || destBE.m_58901_()) {
            this.m_107274_();
        }
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        }
        if (this.destination.m_82531_(this.f_107212_, this.f_107213_, this.f_107214_) <= 0.3) {
            this.m_107274_();
            return;
        }
        this.calculateVector();
        this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
    }

    public static class Provider
    implements ParticleProvider<TuningAuraParticleOptions> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(TuningAuraParticleOptions options, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            return new TuningAuraParticle(level, x, y, z, dx, dy, dz, options, this.sprites);
        }
    }
}

