/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.advancements;

import com.google.gson.JsonObject;
import java.util.function.Function;
import mods.railcraft.api.track.TrackType;
import mods.railcraft.api.track.TrackUtil;
import mods.railcraft.util.Conditions;
import mods.railcraft.util.JsonUtil;
import mods.railcraft.world.level.block.track.TrackTypes;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

final class TrackItemPredicate
extends ItemPredicate {
    static final Function<JsonObject, ItemPredicate> DESERIALIZER = json -> {
        Boolean highSpeed = JsonUtil.getAsBoolean(json, "high_speed").orElse(null);
        Boolean electric = JsonUtil.getAsBoolean(json, "electric").orElse(null);
        TrackType type = JsonUtil.getFromRegistry(json, "track_type", TrackTypes.REGISTRY.get()).orElse(null);
        return new TrackItemPredicate(highSpeed, electric, type);
    };
    @Nullable
    private final Boolean highSpeed;
    @Nullable
    private final Boolean electric;
    @Nullable
    private final TrackType type;

    private TrackItemPredicate(@Nullable Boolean highSpeed, @Nullable Boolean electric, @Nullable TrackType type) {
        this.highSpeed = highSpeed;
        this.electric = electric;
        this.type = type;
    }

    public boolean m_45049_(ItemStack stack) {
        TrackType type = TrackUtil.getTrackType(stack);
        if (!Conditions.check(this.highSpeed, type.isHighSpeed())) {
            return false;
        }
        if (!Conditions.check(this.electric, type.isElectric())) {
            return false;
        }
        if (!Conditions.check(this.type, type)) {
            return false;
        }
        return TrackUtil.isRail(stack);
    }
}

