/*
 * Decompiled with CFR 0.152.
 */
package com.ichphilipp.logicchips.utils;

import java.util.Collection;
import java.util.Objects;

public final class Asser {
    public static void t(boolean condition, String message) {
        if (!condition) {
            throw new AssertionError((Object)message);
        }
    }

    public static void t(boolean condition, String message, Object ... args) {
        if (!condition) {
            throw new AssertionError((Object)String.format(message, args));
        }
    }

    public static void tEqual(Object a, Object b, String message) {
        if (!Objects.equals(a, b)) {
            throw new AssertionError((Object)message);
        }
    }

    public static void tEqual(Object a, Object b) {
        Asser.tEqual(a, b, String.format("'%s' and '%s' are not equal", a, b));
    }

    public static <T> T tNotNull(T value, String name) {
        if (value == null) {
            throw new NullPointerException("'" + name + "' must not be null");
        }
        return value;
    }

    public static <T extends Iterable<?>> T tNotNullAll(T collection, String name) {
        Asser.tNotNull(collection, name);
        String elementName = "element in " + name;
        for (Object o : collection) {
            Asser.tNotNull(o, elementName);
        }
        return collection;
    }

    public static <T extends Collection<?>> T tNotEmpty(T value, String name) {
        Asser.tNotNull(value, name);
        if (value.isEmpty()) {
            throw new NullPointerException("'" + name + "' must not be empty");
        }
        return value;
    }

    public static <T extends CharSequence> T tNotEmpty(T value, String name) {
        Asser.tNotNull(value, name);
        if (value.isEmpty()) {
            throw new NullPointerException("'" + name + "' must not be empty");
        }
        return value;
    }

    private Asser() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

