/*
 * Decompiled with CFR 0.152.
 */
package com.ichphilipp.logicchips.items;

import com.ichphilipp.logicchips.LogicChips;
import com.ichphilipp.logicchips.items.Chip;
import com.ichphilipp.logicchips.items.ChipType;
import com.ichphilipp.logicchips.items.DynamicChip;
import com.ichphilipp.logicchips.utils.RegistryMgr;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;

public final class LogicChipsItem {
    private static final Map<String, RegistrySupplier<? extends Item>> ALL = new LinkedHashMap<String, RegistrySupplier<? extends Item>>();
    public static final RegistrySupplier<Item> CHIP = LogicChipsItem.registerImpl("chip", () -> new Item(LogicChips.DEFAULT_ITEM_PROP));
    public static final RegistrySupplier<Chip> NOT_GATE = LogicChipsItem.registerChip(ChipType.not);
    public static final RegistrySupplier<Chip> AND_GATE = LogicChipsItem.registerChip(ChipType.and);
    public static final RegistrySupplier<Chip> NAND_GATE = LogicChipsItem.registerChip(ChipType.nand);
    public static final RegistrySupplier<Chip> OR_GATE = LogicChipsItem.registerChip(ChipType.or);
    public static final RegistrySupplier<Chip> NOR_GATE = LogicChipsItem.registerChip(ChipType.nor);
    public static final RegistrySupplier<Chip> XOR_GATE = LogicChipsItem.registerChip(ChipType.xor);
    public static final RegistrySupplier<Chip> XNOR_GATE = LogicChipsItem.registerChip(ChipType.xnor);
    public static final RegistrySupplier<Chip> AND_GATE_3 = LogicChipsItem.registerChip(ChipType.and_3);
    public static final RegistrySupplier<Chip> NAND_GATE_3 = LogicChipsItem.registerChip(ChipType.nand_3);
    public static final RegistrySupplier<Chip> OR_GATE_3 = LogicChipsItem.registerChip(ChipType.or_3);
    public static final RegistrySupplier<Chip> NOR_GATE_3 = LogicChipsItem.registerChip(ChipType.nor_3);
    public static final RegistrySupplier<Chip> XOR_GATE_3 = LogicChipsItem.registerChip(ChipType.xor_3);
    public static final RegistrySupplier<Chip> XNOR_GATE_3 = LogicChipsItem.registerChip(ChipType.xnor_3);
    public static final RegistrySupplier<DynamicChip> DYNAMIC = LogicChipsItem.registerImpl(ChipType.dynamic.toChipName(), DynamicChip::new);

    public static Map<String, RegistrySupplier<? extends Item>> getAll() {
        return Collections.unmodifiableMap(ALL);
    }

    static RegistrySupplier<Chip> registerChip(@NotNull ChipType chipType) {
        return LogicChipsItem.registerImpl(chipType.toChipName(), () -> new Chip(chipType));
    }

    static <T extends Item> RegistrySupplier<T> registerImpl(@NotNull String name, @NotNull Supplier<T> supplier) {
        if (ALL.containsKey(name = name.toLowerCase(Locale.ROOT))) {
            throw new IllegalArgumentException("item registry name '" + name + "' already existed");
        }
        RegistrySupplier registered = RegistryMgr.ITEM.register(name, supplier);
        ALL.put(name, (RegistrySupplier<? extends Item>)registered);
        return registered;
    }

    private LogicChipsItem() {
    }
}

