/*
 * Decompiled with CFR 0.152.
 */
package com.ichphilipp.logicchips.items;

import com.ichphilipp.logicchips.items.Chip;
import com.ichphilipp.logicchips.items.ChipType;
import com.ichphilipp.logicchips.utils.BitWiseUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicChip
extends Chip {
    public static final int LOGIC_BITS_SIZE = 8;
    public static final TextColor DARK_YELLOW = TextColor.m_131268_((String)"#404000");
    public static final TextColor REGULAR_YELLOW = TextColor.m_131270_((ChatFormatting)ChatFormatting.YELLOW);
    public static final TextColor DARK_AQUA = TextColor.m_131268_((String)"#004040");
    public static final TextColor REGULAR_AQUA = TextColor.m_131270_((ChatFormatting)ChatFormatting.AQUA);
    public static final TextColor DARK_PURPLE = TextColor.m_131268_((String)"#400040");
    public static final TextColor REGULAR_PURPLE = TextColor.m_131270_((ChatFormatting)ChatFormatting.LIGHT_PURPLE);
    public static final TextColor DARK_RED = TextColor.m_131268_((String)"#400000");
    public static final TextColor REGULAR_RED = TextColor.m_131270_((ChatFormatting)ChatFormatting.RED);

    public DynamicChip() {
        super(ChipType.dynamic);
    }

    @Override
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltips, @NotNull TooltipFlag flag) {
        boolean[] allBool;
        super.m_7373_(stack, level, tooltips, flag);
        boolean[] logicData = DynamicChip.readLogicFromName(stack.m_41786_());
        if (logicData == null) {
            return;
        }
        int logic = BitWiseUtil.wrap(logicData);
        for (boolean left : allBool = new boolean[]{false, true}) {
            for (boolean mid : allBool) {
                for (boolean right : allBool) {
                    MutableComponent tip = Component.m_237119_().m_7220_((Component)DynamicChip.signal(left ? REGULAR_AQUA : DARK_AQUA)).m_130946_(" + ").m_7220_((Component)DynamicChip.signal(mid ? REGULAR_PURPLE : DARK_PURPLE)).m_130946_(" + ").m_7220_((Component)DynamicChip.signal(right ? REGULAR_YELLOW : DARK_YELLOW)).m_130946_(" -> ").m_7220_((Component)DynamicChip.signal(BitWiseUtil.get(logic, BitWiseUtil.wrap(left, mid, right)) ? REGULAR_RED : DARK_RED));
                    tooltips.add((Component)tip);
                }
            }
        }
    }

    @NotNull
    private static MutableComponent signal(TextColor color) {
        return Component.m_237113_((String)"\u2588").m_6270_(Style.f_131099_.m_131148_(color));
    }

    public static boolean @Nullable [] readLogicFromName(@NotNull Component hoverName) {
        String name = hoverName.getString();
        if (name.length() < 8) {
            return null;
        }
        boolean[] logics = new boolean[8];
        for (int i = 0; i < 8; ++i) {
            char c = name.charAt(i);
            if (c == '0') {
                logics[i] = false;
                continue;
            }
            if (c == '1') {
                logics[i] = true;
                continue;
            }
            return null;
        }
        return logics;
    }
}

