/*
 * Decompiled with CFR 0.152.
 */
package com.ichphilipp.logicchips.items;

import com.ichphilipp.logicchips.api.TriBoolLogic;
import java.util.Locale;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ChipType implements StringRepresentable
{
    empty((L, B, R) -> false, 0),
    not((L, B, R) -> !B, 1),
    and((L, B, R) -> L && R, 2),
    nand((L, B, R) -> !L || !R, 2),
    or((L, B, R) -> L || R, 2),
    nor((L, B, R) -> !L && !R, 2),
    xor((L, B, R) -> L ^ R, 2),
    xnor((L, B, R) -> L == R, 2),
    and_3((L, B, R) -> L && B && R, 2),
    nand_3((L, B, R) -> !L || !B || !R, 3),
    or_3((L, B, R) -> L || B || R, 3),
    nor_3((L, B, R) -> !L && !B && !R, 3),
    xor_3((L, B, R) -> ((L ? 1 : 0) + (B ? 1 : 0) + (R ? 1 : 0)) % 2 == 1, 3),
    xnor_3((L, B, R) -> ((L ? 1 : 0) + (B ? 1 : 0) + (R ? 1 : 0)) % 2 == 0, 3),
    dynamic(null, 3);

    @Nullable
    public final TriBoolLogic logic;
    public final boolean canConnectLeft;
    public final boolean canConnectMid;
    public final boolean canConnectRight;

    private ChipType(TriBoolLogic logic, int canConnect) {
        this.logic = logic;
        this.canConnectLeft = canConnect == 2 || canConnect == 3;
        this.canConnectRight = canConnect == 2 || canConnect == 3;
        this.canConnectMid = canConnect == 1 || canConnect == 3;
    }

    @NotNull
    public String m_7912_() {
        return this.name();
    }

    public String toChipName() {
        String typeName = this.name().toLowerCase(Locale.ROOT);
        return typeName.endsWith("_3") ? typeName.substring(0, typeName.length() - "_3".length()) + "_gate_3" : typeName + "_gate";
    }

    public boolean isDynamic() {
        return this.logic == null;
    }
}

