/*
 * Decompiled with CFR 0.152.
 */
package com.ichphilipp.logicchips.blocks;

import com.ichphilipp.logicchips.blocks.ChipFrameEntity;
import com.ichphilipp.logicchips.items.Chip;
import com.ichphilipp.logicchips.items.ChipType;
import com.ichphilipp.logicchips.items.DynamicChip;
import com.ichphilipp.logicchips.items.LogicChipsItem;
import com.ichphilipp.logicchips.utils.BitWiseUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChipFrame
extends DiodeBlock
implements EntityBlock {
    public static final EnumProperty<ChipType> TYPE = EnumProperty.m_61587_((String)"type", ChipType.class);
    public static final BooleanProperty LEFT_INPUT = BooleanProperty.m_61465_((String)"left");
    public static final BooleanProperty RIGHT_INPUT = BooleanProperty.m_61465_((String)"right");
    public static final BooleanProperty BOTTOM_INPUT = BooleanProperty.m_61465_((String)"bottom");

    public ChipFrame(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_(TYPE, (Comparable)((Object)ChipType.empty))).m_61124_((Property)LEFT_INPUT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT_INPUT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BOTTOM_INPUT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_52496_, (Comparable)Boolean.valueOf(false)));
    }

    protected int m_6112_(@NotNull BlockState state) {
        return 0;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> arg) {
        arg.m_61104_(new Property[]{f_54117_, TYPE, f_52496_, LEFT_INPUT, RIGHT_INPUT, BOTTOM_INPUT});
    }

    public boolean canConnectRedstone(BlockState blockState, BlockGetter world, BlockPos pos, @Nullable Direction side) {
        ChipType type = (ChipType)((Object)blockState.m_61143_(TYPE));
        Direction facing = (Direction)blockState.m_61143_((Property)f_54117_);
        return side == facing || type.canConnectRight && side == facing.m_122427_() || type.canConnectLeft && side == facing.m_122428_() || type.canConnectMid && side == facing.m_122424_();
    }

    protected int m_7312_(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state) {
        return this.isPowered(state, world, pos) ? 15 : 0;
    }

    public void m_6810_(@NotNull BlockState blockState, @NotNull Level world, @NotNull BlockPos blockPos, @NotNull BlockState newblockState, boolean isMoving) {
        if (!isMoving && !blockState.m_60713_(newblockState.m_60734_())) {
            super.m_6810_(blockState, world, blockPos, newblockState, false);
            this.dropChip(world, blockPos, blockState);
        }
    }

    public boolean isPowered(@NotNull BlockState blockstate, Level world, @NotNull BlockPos pos) {
        Direction facing = (Direction)blockstate.m_61143_((Property)f_54117_);
        ChipType type = (ChipType)((Object)blockstate.m_61143_(TYPE));
        boolean signalR = 0 != this.getFaceSignal(world, pos, facing.m_122428_());
        boolean signalM = 0 != this.getFaceSignal(world, pos, facing);
        boolean signalL = 0 != this.getFaceSignal(world, pos, facing.m_122427_());
        world.m_46597_(pos, (BlockState)((BlockState)((BlockState)blockstate.m_61124_((Property)LEFT_INPUT, (Comparable)Boolean.valueOf(signalL))).m_61124_((Property)RIGHT_INPUT, (Comparable)Boolean.valueOf(signalR))).m_61124_((Property)BOTTOM_INPUT, (Comparable)Boolean.valueOf(signalM)));
        if (type.logic == null) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof ChipFrameEntity) {
                ChipFrameEntity entity = (ChipFrameEntity)blockEntity;
                return BitWiseUtil.get(entity.dynamicLogics, BitWiseUtil.wrap(signalL, signalM, signalR));
            }
            return false;
        }
        return type.logic.apply(signalL, signalM, signalR);
    }

    private int getFaceSignal(Level world, @NotNull BlockPos pos, Direction facing) {
        return world.m_277094_(pos.m_121945_(facing), facing, this.m_276978_());
    }

    public void dropChip(Level world, BlockPos pos, BlockState blockState) {
        ChipType type = (ChipType)((Object)blockState.m_61143_(TYPE));
        if (type == ChipType.empty) {
            return;
        }
        Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)ChipFrame.computeStackForDrop(world, pos, blockState));
        this.m_52580_(world, pos, blockState);
    }

    private static ItemStack computeStackForDrop(Level world, BlockPos pos, BlockState blockState) {
        ChipType type = (ChipType)((Object)blockState.m_61143_(TYPE));
        if (type == ChipType.dynamic) {
            ItemStack stack = ((DynamicChip)((Object)LogicChipsItem.DYNAMIC.get())).m_7968_().m_255036_(1);
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof ChipFrameEntity) {
                ChipFrameEntity entity = (ChipFrameEntity)blockEntity;
                StringBuilder builder = new StringBuilder(8);
                int logic = entity.dynamicLogics;
                for (int i = 0; i < 8; ++i) {
                    builder.append(BitWiseUtil.get(logic, i) ? (char)'1' : '0');
                }
                stack.m_41714_((Component)Component.m_237113_((String)builder.toString()));
            }
            return stack;
        }
        return ((Item)LogicChipsItem.getAll().get(type.toChipName()).get()).m_7968_().m_255036_(1);
    }

    @NotNull
    public InteractionResult m_6227_(BlockState blockState, @NotNull Level world, @NotNull BlockPos blockPos, Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        ChipType type = (ChipType)((Object)blockState.m_61143_(TYPE));
        ItemStack stack = player.m_21120_(hand);
        Item handitem = stack.m_41720_();
        boolean instabuild = !player.m_150110_().f_35937_;
        boolean isClientSide = world.f_46443_;
        if (type == ChipType.empty && handitem instanceof Chip) {
            if (!isClientSide) {
                BlockEntity blockEntity;
                ChipType newType = ((Chip)handitem).type;
                if (newType == ChipType.dynamic && (blockEntity = world.m_7702_(blockPos)) instanceof ChipFrameEntity) {
                    ChipFrameEntity entity = (ChipFrameEntity)blockEntity;
                    boolean[] logicRaw = DynamicChip.readLogicFromName(stack.m_41786_());
                    if (logicRaw == null) {
                        return InteractionResult.PASS;
                    }
                    entity.dynamicLogics = BitWiseUtil.wrap(logicRaw);
                    entity.m_6596_();
                }
                world.m_7731_(blockPos, (BlockState)((BlockState)blockState.m_61124_(TYPE, (Comparable)((Object)newType))).m_61124_((Property)f_52496_, (Comparable)Boolean.valueOf(this.isPowered(blockState, world, blockPos))), 3);
                if (instabuild) {
                    stack.m_41774_(1);
                }
                world.m_5594_(null, blockPos, SoundEvents.f_12015_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.m_19078_((boolean)isClientSide);
        }
        if (type != ChipType.empty) {
            if (!isClientSide) {
                world.m_7731_(blockPos, (BlockState)((BlockState)blockState.m_61124_(TYPE, (Comparable)((Object)ChipType.empty))).m_61124_((Property)f_52496_, (Comparable)Boolean.valueOf(false)), 3);
                this.dropChip(world, blockPos, blockState);
                world.m_5594_(null, blockPos, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.m_19078_((boolean)isClientSide);
        }
        return InteractionResult.PASS;
    }

    public void m_214162_(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        if (!((Boolean)blockState.m_61143_((Property)f_52496_)).booleanValue()) {
            return;
        }
        Direction direction = (Direction)blockState.m_61143_((Property)f_54117_);
        double x = (double)blockPos.m_123341_() + 0.5 + (randomSource.m_188500_() - 0.5) * 0.2;
        double y = (double)blockPos.m_123342_() + 0.4 + (randomSource.m_188500_() - 0.5) * 0.2;
        double z = (double)blockPos.m_123343_() + 0.5 + (randomSource.m_188500_() - 0.5) * 0.2;
        float scale = -5.0f;
        if (randomSource.m_188499_()) {
            x += (double)((scale /= 16.0f) * (float)direction.m_122429_());
            z += (double)(scale * (float)direction.m_122431_());
        }
        level.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, x, y, z, 0.0, 0.0, 0.0);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new ChipFrameEntity(blockPos, blockState);
    }
}

