/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.forge.common;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraftforge.server.permission.events.PermissionGatherEvent;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContextKey;
import net.minecraftforge.server.permission.nodes.PermissionNode;
import net.minecraftforge.server.permission.nodes.PermissionTypes;

public class ForgePermissions {
    private static final Map<String, PermissionNode<Boolean>> PERMISSIONS = ForgePermissions.build("command.config", "command.settings", "command.statistics");

    public static PermissionNode<Boolean> getPermissionNode(String node) {
        return PERMISSIONS.get(node);
    }

    public static void addNodes(PermissionGatherEvent.Nodes event) {
        for (PermissionNode<Boolean> node : PERMISSIONS.values()) {
            event.addNodes(new PermissionNode[]{node});
        }
    }

    private static Map<String, PermissionNode<Boolean>> build(String ... nodes) {
        Object2ObjectOpenHashMap permissions = new Object2ObjectOpenHashMap();
        for (String node : nodes) {
            permissions.put(node, new PermissionNode("servercore", node, PermissionTypes.BOOLEAN, (x, y, z) -> false, new PermissionDynamicContextKey[0]));
        }
        return permissions;
    }
}

