/*
 * Decompiled with CFR 0.152.
 */
package net.tejty.gamediscs.games.util;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import net.tejty.gamediscs.games.graphics.AnimatedImage;
import net.tejty.gamediscs.games.graphics.Image;
import net.tejty.gamediscs.games.graphics.Renderer;

public class Sprite {
    private Vec2 pos = Vec2.f_82462_;
    private Vec2 size = Vec2.f_82462_;
    private Vec2 vel = Vec2.f_82462_;
    private Renderer image = new Renderer();
    private boolean shown = true;

    public Sprite(Vec2 pos, Vec2 size, Renderer image) {
        this.pos = pos;
        this.size = size;
        this.image = image;
    }

    public Sprite(Vec2 pos, Vec2 size, ResourceLocation image) {
        this.pos = pos;
        this.size = size;
        this.image = new Image(image, (int)size.f_82470_, (int)size.f_82471_);
    }

    public Vec2 getPos() {
        return this.pos;
    }

    public float getX() {
        return this.pos.f_82470_;
    }

    public float getY() {
        return this.pos.f_82471_;
    }

    public Vec2 getCenterPos() {
        return this.pos.m_165910_(this.size.m_165903_(0.5f));
    }

    public void setPos(Vec2 pos) {
        this.pos = pos;
    }

    public void setX(float x) {
        this.pos = new Vec2(x, this.getY());
    }

    public void setY(float y) {
        this.pos = new Vec2(this.getX(), y);
    }

    public void moveBy(Vec2 offset) {
        this.pos = this.pos.m_165910_(offset);
    }

    public Vec2 getSize() {
        return this.size;
    }

    public float getWidth() {
        return this.size.f_82470_;
    }

    public float getHeight() {
        return this.size.f_82471_;
    }

    public void setSize(Vec2 size) {
        this.size = size;
    }

    public Vec2 getVelocity() {
        return this.vel;
    }

    public Sprite setVelocity(Vec2 vel) {
        this.vel = vel;
        return this;
    }

    public Sprite addVelocity(Vec2 vel) {
        this.vel = this.vel.m_165910_(vel);
        return this;
    }

    public Renderer getImage() {
        return this.image;
    }

    public void setImage(Renderer image) {
        this.image = image;
    }

    public void setImage(ResourceLocation image) {
        this.image = new Image(image, (int)this.size.f_82470_, (int)this.size.f_82471_);
    }

    public void show() {
        this.shown = true;
    }

    public void hide() {
        this.shown = false;
    }

    public void tick() {
        this.pos = this.pos.m_165910_(this.vel);
    }

    public void animTick() {
        Renderer renderer = this.image;
        if (renderer instanceof AnimatedImage) {
            AnimatedImage animation = (AnimatedImage)renderer;
            animation.tick();
        }
    }

    public boolean isTouching(Sprite other) {
        return this.getX() < other.getX() + other.getWidth() && this.getX() + this.getWidth() > other.getX() && this.getY() < other.getY() + other.getHeight() && this.getY() + this.getHeight() > other.getY();
    }

    public void render(GuiGraphics graphics, int gameX, int gameY) {
        if (this.shown) {
            this.image.render(graphics, gameX + (int)this.pos.f_82470_, gameY + (int)this.pos.f_82471_);
        }
    }
}

