/*
 * Decompiled with CFR 0.152.
 */
package net.tejty.gamediscs.games.graphics;

import java.util.List;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.resources.ResourceLocation;
import net.tejty.gamediscs.games.graphics.Image;
import net.tejty.gamediscs.games.graphics.MultiImage;

public class AnimatedImage
extends MultiImage {
    private final int duration;
    private int timer = 0;

    public AnimatedImage(List<Image> images, int duration) {
        super(images);
        this.duration = duration;
    }

    public AnimatedImage(ResourceLocation file, int fileWidth, int fileHeight, List<Rect2i> rects, int duration) {
        super(file, fileWidth, fileHeight, rects);
        this.duration = duration;
    }

    public AnimatedImage(ResourceLocation file, int fileWidth, int fileHeight, int frames, int duration) {
        this(file, fileWidth, fileHeight, AnimatedImage.fromFile(fileWidth, fileHeight, frames), duration);
    }

    public AnimatedImage tick() {
        ++this.timer;
        if (this.timer >= this.duration) {
            if (this.current() >= this.count() - 1) {
                this.setImage(0);
            } else {
                this.setImage(this.current() + 1);
            }
        }
        return this;
    }
}

